/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class MotifBorders {
    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2, Color color, Color color2, Color color3, Color color4) {
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        if (bl) {
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.setColor(color);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.setColor(color2);
            graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
            graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 4);
        } else {
            if (bl2) {
                graphics.setColor(color4);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.setColor(color2);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 4, 1);
                graphics.setColor(color);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 1, n3 - 3, n4 - 4);
                graphics.setColor(color3);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 4, 1);
                graphics.setColor(color);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 1, n3 - 3, n4 - 4);
                graphics.setColor(color3);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 0);
            }
            graphics.translate(-n, -n2);
        }
        graphics.setColor(color5);
    }

    public static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private Color darkShadow = UIManager.getColor("controlShadow");
        private Color lightShadow = UIManager.getColor("controlLtHighlight");
        private boolean isRaised;

        public BevelBorder(boolean bl, Color color, Color color2) {
            this.isRaised = bl;
            this.darkShadow = color;
            this.lightShadow = color2;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isOpaque(Component component) {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + n4 - 1, n, n2 + 1);
            graphics.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + 1);
        }
    }

    public static class FocusBorder
    extends AbstractBorder
    implements UIResource {
        private Color focus;
        private Color control;
        static final Insets insets = new Insets(1, 1, 1, 1);

        public FocusBorder(Color color, Color color2) {
            this.control = color;
            this.focus = color2;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((JComponent)component).hasFocus()) {
                graphics.setColor(this.focus);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            } else {
                graphics.setColor(this.control);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Color focus = UIManager.getColor("activeCaptionBorder");
        protected Color shadow = UIManager.getColor("controlShadow");
        protected Color highlight = UIManager.getColor("controlHighlight");
        protected Color darkShadow;

        public ButtonBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color;
            this.highlight = color2;
            this.darkShadow = color3;
            this.focus = color4;
        }

        public Insets getBorderInsets(Component component) {
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                return jButton.isDefaultCapable() ? new Insets(8, 8, 8, 8) : new Insets(2, 2, 2, 2);
            }
            return new Insets(2, 2, 2, 2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                bl = buttonModel.isArmed() && buttonModel.isPressed();
                boolean bl5 = bl2 = buttonModel.isArmed() && bl || abstractButton.isFocusPainted() && abstractButton.hasFocus();
                if (abstractButton instanceof JButton) {
                    bl3 = ((JButton)abstractButton).isDefaultCapable();
                    bl4 = ((JButton)abstractButton).isDefaultButton();
                }
            }
            int n5 = n + 1;
            int n6 = n2 + 1;
            int n7 = n + n3 - 2;
            int n8 = n2 + n4 - 2;
            if (bl3) {
                if (bl4) {
                    graphics.setColor(this.shadow);
                    graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + n4 - 4);
                    graphics.drawLine(n + 3, n2 + 3, n + n3 - 4, n2 + 3);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(n + 4, n2 + n4 - 4, n + n3 - 4, n2 + n4 - 4);
                    graphics.drawLine(n + n3 - 4, n2 + 3, n + n3 - 4, n2 + n4 - 4);
                }
                n5 += 6;
                n6 += 6;
                n7 -= 6;
                n8 -= 6;
            }
            if (bl2) {
                graphics.setColor(this.focus);
                if (bl4) {
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                } else {
                    graphics.drawRect(n5 - 1, n6 - 1, n7 - n5 + 2, n8 - n6 + 2);
                }
            }
            graphics.setColor(bl ? this.shadow : this.highlight);
            graphics.drawLine(n5, n6, n7, n6);
            graphics.drawLine(n5, n6, n5, n8);
            graphics.setColor(bl ? this.highlight : this.shadow);
            graphics.drawLine(n7, n6 + 1, n7, n8);
            graphics.drawLine(n5 + 1, n8, n7, n8);
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public ToggleButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 3, 3);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    MotifBorders.drawBezel(graphics, n, n2, n3, n4, buttonModel.isPressed() || buttonModel.isSelected(), abstractButton.isFocusPainted() && abstractButton.hasFocus(), this.shadow, this.highlight, this.darkShadow, this.focus);
                } else {
                    MotifBorders.drawBezel(graphics, n, n2, n3, n4, false, abstractButton.isFocusPainted() && abstractButton.hasFocus(), this.shadow, this.highlight, this.darkShadow, this.focus);
                }
            } else {
                MotifBorders.drawBezel(graphics, n, n2, n3, n4, false, false, this.shadow, this.highlight, this.darkShadow, this.focus);
            }
        }
    }

    public static class MenuBarBorder
    extends ButtonBorder {
        public MenuBarBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(6, 6, 6, 6);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuBar jMenuBar = (JMenuBar)component;
            if (jMenuBar.isBorderPainted()) {
                Dimension dimension = jMenuBar.getSize();
                MotifBorders.drawBezel(graphics, n, n2, dimension.width, dimension.height, false, false, this.shadow, this.highlight, this.darkShadow, this.focus);
            }
        }
    }

    public static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        JComponent jcomp;
        Color frameHighlight;
        Color frameColor;
        Color frameShadow;
        public static final int BORDER_SIZE = 5;
        static Insets insets = new Insets(5, 5, 5, 5);

        public FrameBorder(JComponent jComponent) {
            this.jcomp = jComponent;
        }

        public JComponent component() {
            return this.jcomp;
        }

        protected boolean drawBottomBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(0, n4 - this.getBorderInsets((Component)component).bottom, n3, this.getBorderInsets((Component)component).bottom);
            if (!graphics.getClipBounds().intersects(rectangle)) {
                return false;
            }
            int n5 = n4 - this.getBorderInsets((Component)component).bottom;
            graphics.setColor(this.frameShadow);
            graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n + 2, n4 - 2, n3 - 2, n4 - 2);
            graphics.setColor(this.frameColor);
            graphics.fillRect(n + 2, n5 + 1, n3 - 4, 2);
            graphics.setColor(this.frameHighlight);
            graphics.drawLine(n + 5, n5, n3 - 5, n5);
            return true;
        }

        protected boolean drawLeftBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(0, 0, this.getBorderInsets((Component)component).left, n4);
            if (!graphics.getClipBounds().intersects(rectangle)) {
                return false;
            }
            int n5 = 5;
            graphics.setColor(this.frameHighlight);
            graphics.drawLine(n, n5, n, n4 - 1);
            graphics.drawLine(n + 1, n5, n + 1, n4 - 2);
            graphics.setColor(this.frameColor);
            graphics.fillRect(n + 2, n5, n + 2, n4 - 3);
            graphics.setColor(this.frameShadow);
            graphics.drawLine(n + 4, n5, n + 4, n4 - 5);
            return true;
        }

        protected boolean drawRightBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(n3 - this.getBorderInsets((Component)component).right, 0, this.getBorderInsets((Component)component).right, n4);
            if (!graphics.getClipBounds().intersects(rectangle)) {
                return false;
            }
            int n5 = n3 - this.getBorderInsets((Component)component).right;
            int n6 = 5;
            graphics.setColor(this.frameColor);
            graphics.fillRect(n5 + 1, n6, 2, n4 - 1);
            graphics.setColor(this.frameShadow);
            graphics.fillRect(n5 + 3, n6, 2, n4 - 1);
            graphics.setColor(this.frameHighlight);
            graphics.drawLine(n5, n6, n5, n4 - 1);
            return true;
        }

        protected boolean drawTopBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(n, n2, n3, 5);
            if (!graphics.getClipBounds().intersects(rectangle)) {
                return false;
            }
            int n5 = n3 - 1;
            int n6 = 4;
            graphics.setColor(this.frameColor);
            graphics.drawLine(n, n2 + 2, n5 - 2, n2 + 2);
            graphics.drawLine(n, n2 + 3, n5 - 2, n2 + 3);
            graphics.drawLine(n, n2 + 4, n5 - 2, n2 + 4);
            graphics.setColor(this.frameHighlight);
            graphics.drawLine(n, n2, n5, n2);
            graphics.drawLine(n, n2 + 1, n5, n2 + 1);
            graphics.drawLine(n, n2 + 2, n, n2 + 4);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 4);
            graphics.setColor(this.frameShadow);
            graphics.drawLine(n + 4, n2 + 4, n5 - 4, n2 + 4);
            graphics.drawLine(n5, n2 + 1, n5, n6);
            graphics.drawLine(n5 - 1, n2 + 2, n5 - 1, n6);
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        protected Color getFrameColor() {
            return this.frameColor;
        }

        protected Color getFrameHighlight() {
            return this.frameHighlight;
        }

        protected Color getFrameShadow() {
            return this.frameShadow;
        }

        protected boolean isActiveFrame() {
            return this.jcomp.hasFocus();
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.frameColor = this.isActiveFrame() ? UIManager.getColor("activeCaptionBorder") : UIManager.getColor("inactiveCaptionBorder");
            this.frameHighlight = this.frameColor.brighter();
            this.frameShadow = this.frameColor.darker().darker();
            this.drawTopBorder(component, graphics, n, n2, n3, n4);
            this.drawLeftBorder(component, graphics, n, n2, n3, n4);
            this.drawRightBorder(component, graphics, n, n2, n3, n4);
            this.drawBottomBorder(component, graphics, n, n2, n3, n4);
        }

        public void setComponent(JComponent jComponent) {
            this.jcomp = jComponent;
        }
    }

    public static class InternalFrameBorder
    extends FrameBorder {
        JInternalFrame frame;
        public static final int CORNER_SIZE = 24;

        public InternalFrameBorder(JInternalFrame jInternalFrame) {
            super(jInternalFrame);
            this.frame = jInternalFrame;
        }

        protected boolean drawBottomBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (super.drawBottomBorder(component, graphics, n, n2, n3, n4) && this.frame.isResizable()) {
                int n5 = n4 - this.getBorderInsets((Component)component).bottom;
                graphics.setColor(this.getFrameShadow());
                graphics.drawLine(23, n5 + 1, 23, n4 - 1);
                graphics.drawLine(n3 - 24, n5 + 1, n3 - 24, n4 - 1);
                graphics.setColor(this.getFrameHighlight());
                graphics.drawLine(24, n5, 24, n4 - 2);
                graphics.drawLine(n3 - 24 + 1, n5, n3 - 24 + 1, n4 - 2);
                return true;
            }
            return false;
        }

        protected boolean drawLeftBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (super.drawLeftBorder(component, graphics, n, n2, n3, n4) && this.frame.isResizable()) {
                graphics.setColor(this.getFrameHighlight());
                int n5 = n2 + 24;
                graphics.drawLine(n, n5, n + 4, n5);
                int n6 = n4 - 24;
                graphics.drawLine(n + 1, n6, n + 5, n6);
                graphics.setColor(this.getFrameShadow());
                graphics.drawLine(n + 1, n5 - 1, n + 5, n5 - 1);
                graphics.drawLine(n + 1, n6 - 1, n + 5, n6 - 1);
                return true;
            }
            return false;
        }

        protected boolean drawRightBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (super.drawRightBorder(component, graphics, n, n2, n3, n4) && this.frame.isResizable()) {
                int n5 = n3 - this.getBorderInsets((Component)component).right;
                graphics.setColor(this.getFrameHighlight());
                int n6 = n2 + 24;
                graphics.drawLine(n5, n6, n3 - 2, n6);
                int n7 = n4 - 24;
                graphics.drawLine(n5 + 1, n7, n5 + 3, n7);
                graphics.setColor(this.getFrameShadow());
                graphics.drawLine(n5 + 1, n6 - 1, n3 - 2, n6 - 1);
                graphics.drawLine(n5 + 1, n7 - 1, n5 + 3, n7 - 1);
                return true;
            }
            return false;
        }

        protected boolean drawTopBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (super.drawTopBorder(component, graphics, n, n2, n3, n4) && this.frame.isResizable()) {
                graphics.setColor(this.getFrameShadow());
                graphics.drawLine(23, n2 + 1, 23, n2 + 4);
                graphics.drawLine(n3 - 24 - 1, n2 + 1, n3 - 24 - 1, n2 + 4);
                graphics.setColor(this.getFrameHighlight());
                graphics.drawLine(24, n2, 24, n2 + 4);
                graphics.drawLine(n3 - 24, n2, n3 - 24, n2 + 4);
                return true;
            }
            return false;
        }

        public JInternalFrame frame() {
            return this.frame;
        }

        protected boolean isActiveFrame() {
            return this.frame.isSelected();
        }

        public int resizePartWidth() {
            if (!this.frame.isResizable()) {
                return 0;
            }
            return 5;
        }

        public void setFrame(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
        }
    }
}

