/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.io.File;

public final class Skype {
    public static final String LIBRARY_VERSION = "1.0.0.0";
    private static Object userThreadFieldMutex = new Object();
    private static Thread userThread;
    private static SkypeExceptionHandler defaultExceptionHandler;
    private static SkypeExceptionHandler exceptionHandler;

    static {
        exceptionHandler = defaultExceptionHandler = new SkypeExceptionHandler(){

            public void uncaughtExceptionHappened(Throwable e) {
                e.printStackTrace();
            }
        };
    }

    public static void setDeamon(boolean on) {
        Skype.setDaemon(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDaemon(boolean on) {
        Object object = userThreadFieldMutex;
        synchronized (object) {
            if (!on && userThread == null) {
                userThread = new Thread("SkypeUserThread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object wait;
                        Object object = wait = new Object();
                        synchronized (object) {
                            try {
                                wait.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                userThread.start();
            } else if (on && userThread != null) {
                userThread.interrupt();
                userThread = null;
            }
        }
    }

    public static void setDebug(boolean on) throws SkypeException {
        try {
            System.out.println("SKYPE: Try to get Instance");
            Connector con = Connector.getInstance();
            System.out.println("SKYPE: got soemthing");
            if (con != null) {
                System.out.println("SKYPE: start debug on");
                con.setDebug(on);
                System.out.println("SKYPE: end debug on");
            }
        }
        catch (ConnectorException e) {
            System.out.println("SKYPE: exception in etDebugOn");
            e.printStackTrace();
            Utils.convertToSkypeException(e);
        }
    }

    public static String getVersion() throws SkypeException {
        return Utils.getProperty("SKYPEVERSION");
    }

    public static boolean isInstalled() {
        String path = Skype.getInstalledPath();
        if (path == null) {
            return false;
        }
        return new File(path).exists();
    }

    public static String getInstalledPath() {
        return Connector.getInstance().getInstalledPath();
    }

    public static boolean isRunning() throws SkypeException {
        try {
            return Connector.getInstance().isRunning();
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return false;
        }
    }

    public static Application addApplication(String name) throws SkypeException {
        Utils.checkNotNull("name", name);
        return Application.getInstance(name);
    }

    private static String convertNullToDefaultDevice(String deviceName) {
        if (deviceName == null) {
            return "";
        }
        return deviceName;
    }

    public static void setSkypeExceptionHandler(SkypeExceptionHandler handler) {
        if (handler == null) {
            handler = defaultExceptionHandler;
        }
        exceptionHandler = handler;
    }

    static void handleUncaughtException(Throwable e) {
        exceptionHandler.uncaughtExceptionHappened(e);
    }

    private Skype() {
    }
}

