/*
 * Decompiled with CFR 0.152.
 */
package anon.util.captcha;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BinaryImageExtractor {
    public static Image binaryToImage(byte[] byArray) {
        Image image = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n < 0 || n2 < 0 || byArray.length != 8 + (n2 * n + 7) / 8) {
                throw new Exception("BinaryImageExtractor: binaryToImage: The binary image has an invalid size.");
            }
            int[] nArray = new int[n * n2];
            int n3 = byteArrayInputStream.read();
            for (int i = 0; i < n * n2; ++i) {
                nArray[i] = (n3 & 0x80) == 128 ? Color.darkGray.getRGB() : Color.white.getRGB();
                n3 <<= 1;
                if (i % 8 != 7) continue;
                n3 = byteArrayInputStream.read();
            }
            image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        }
        catch (Exception exception) {
            image = null;
        }
        return image;
    }
}

