/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509KeyIdentifier;
import anon.crypto.ByteSignature;
import anon.crypto.IMyPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;

public final class X509SubjectKeyIdentifier
extends AbstractX509KeyIdentifier {
    public static final String IDENTIFIER = X509Extensions.SubjectKeyIdentifier.getId();

    public X509SubjectKeyIdentifier(IMyPublicKey iMyPublicKey) {
        super(IDENTIFIER, X509SubjectKeyIdentifier.createDEROctets(iMyPublicKey));
        this.createValue();
    }

    public X509SubjectKeyIdentifier(DERSequence dERSequence) {
        super(dERSequence);
        this.createValue();
    }

    public String getName() {
        return "SubjectKeyIdentifier";
    }

    private static byte[] createDEROctets(IMyPublicKey iMyPublicKey) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)((DEROctetString)new SubjectKeyIdentifier(iMyPublicKey.getAsSubjectPublicKeyInfo()).getDERObject()));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not write DER object to bytes!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void createValue() {
        byte[] byArray;
        try {
            byArray = ((DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(this.getDEROctets())).readObject()).getOctets();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not read subject key identifier from byte array!");
        }
        this.m_value = ByteSignature.toHexString(byArray);
    }
}

