/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.ListenerInterface;
import anon.util.JAPMessages;
import gui.MixConfigTextField;
import gui.TitledGridBagPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.infoservice.InfoServiceData;
import mixconfig.infoservice.InfoServiceDialog;
import mixconfig.infoservice.InfoServiceTableModel;
import mixconfig.network.ConnectionData;
import mixconfig.network.IncomingConnectionTableModel;
import mixconfig.network.IncomingDialog;
import mixconfig.panels.MixConfigPanel;
import mixconfig.panels.MixOnCDPanel;

public class GeneralPanel
extends MixConfigPanel
implements ActionListener,
TableModelListener,
ChangeListener {
    public static final String XMLPATH_GENERAL = "General";
    public static final String XMLPATH_GENERAL_MIXTYPE = "General/MixType";
    public static final String XMLPATH_GENERAL_CASCADENAME = "General/CascadeName";
    public static final String XMLPATH_GENERAL_MIN_CASCADELENGTH = "General/MinCascadeLength";
    public static final String XMLPATH_GENERAL_MIXNAME = "General/MixName";
    public static final String XMLPATH_GENERAL_OPERATORNAME = "General/OperatorName";
    public static final String XMLPATH_GENERAL_MIXID = "General/MixID";
    public static final String XMLPATH_AUTOCONFIGURATION = "Network/InfoService/AllowAutoConfiguration";
    public static final String XML_ATTRIBUTE_FALLBACK = "fallback";
    public static final String XML_ATTRIBUTE_PAYMENT = "payment";
    private static final String MSG_MIX_TYPE = "Mix Type";
    private static final String MSG_MIX_NAME = "Mix Name";
    private static final String MSG_CASCADE_NAME = "Cascade Name";
    private static final String MSG_FIRST_MIX = GeneralPanel.class.getName() + "_firstMix";
    private static final String MSG_MIDDLE_MIX = GeneralPanel.class.getName() + "_middleMix";
    private static final String MSG_LAST_MIX = GeneralPanel.class.getName() + "_lastMix";
    private static final String MSG_CONFIGURATION_STATIC = GeneralPanel.class.getName() + "_configStatic";
    private static final String MSG_CONFIGURATION_DYNAMIC = GeneralPanel.class.getName() + "_configDynamic";
    private static final String MSG_ALLOW_DYNAMIC_FALLBACK = GeneralPanel.class.getName() + "_allowDynamicFallback";
    private static final String MSG_ENABLE_PAYMENT = GeneralPanel.class.getName() + "_enablePayment";
    private static final String MSG_EXPERIMENTAL_FEATURE = GeneralPanel.class.getName() + "_experimentalFeature";
    private static final String MSG_TOO_MANY_INTERFACES = GeneralPanel.class.getName() + "_tooManyInterfaces";
    private static final String ACTION_UPDATE_IS = "UpdateInfoServices";
    public static final String PSEUDO_CASCADE_NAME = "******Dynamic cascade bug*******";
    private JComboBox m_combxMixType;
    private JComboBox m_combxConfiguration;
    private JComboBox m_combxCascadeLength;
    private JCheckBox m_cbxDynamicFallback;
    private JTextField m_tfCascadeName;
    private JLabel m_cascadeNameLabel;
    private JLabel m_lblCascadeLength;
    private TitledGridBagPanel m_panelGeneralSettings;
    private JLabel m_lblMixType;
    protected int m_mixTypeRow;
    private JCheckBox m_cbxPayment;
    private JCheckBox m_cbxIgnoreOwnName;
    private JPanel m_infoServicePanel;
    private JTable m_infoServiceTable;
    private InfoServiceTableModel m_infoServiceModel;
    private JPanel m_listenerPanel;
    private JTable m_listenerTable;
    private IncomingConnectionTableModel m_listenerModel;

    public GeneralPanel() {
        super(XMLPATH_GENERAL);
        GridBagConstraints c = this.getInitialConstraints();
        this.m_panelGeneralSettings = new TitledGridBagPanel("General Settings");
        this.add((Component)this.m_panelGeneralSettings, c);
        this.m_combxConfiguration = new JComboBox();
        this.m_combxConfiguration.setName(XMLPATH_AUTOCONFIGURATION);
        this.m_combxConfiguration.addItem(JAPMessages.getString(MSG_CONFIGURATION_STATIC));
        this.m_combxConfiguration.addItemListener(this);
        this.m_cbxDynamicFallback = new JCheckBox(JAPMessages.getString(MSG_ALLOW_DYNAMIC_FALLBACK));
        this.m_cbxDynamicFallback.setToolTipText(JAPMessages.getString(MSG_EXPERIMENTAL_FEATURE));
        this.m_cbxDynamicFallback.setName("Network/InfoService/AllowAutoConfiguration/fallback");
        this.m_cbxDynamicFallback.addItemListener(this);
        this.m_cbxDynamicFallback.setEnabled(false);
        this.m_panelGeneralSettings.addRow(new JLabel("Mix Configuration"), this.m_combxConfiguration, this.m_cbxDynamicFallback, null, 2);
        this.m_lblMixType = new JLabel(MSG_MIX_TYPE);
        this.m_combxMixType = new JComboBox();
        this.m_combxMixType.setName(XMLPATH_GENERAL_MIXTYPE);
        this.m_combxMixType.addItem(JAPMessages.getString(MSG_FIRST_MIX));
        this.m_combxMixType.addItem(JAPMessages.getString(MSG_MIDDLE_MIX));
        this.m_combxMixType.addItem(JAPMessages.getString(MSG_LAST_MIX));
        this.m_combxMixType.addItemListener(this);
        this.m_cbxPayment = new JCheckBox(JAPMessages.getString(MSG_ENABLE_PAYMENT));
        this.m_cbxPayment.setToolTipText(JAPMessages.getString(MSG_ENABLE_PAYMENT));
        this.m_cbxPayment.setName("General/MixType/payment");
        this.m_cbxPayment.addItemListener(this);
        this.m_mixTypeRow = this.m_panelGeneralSettings.addRow(this.m_lblMixType, this.m_combxMixType, this.m_cbxPayment, null, 2);
        this.m_tfCascadeName = new MixConfigTextField(20);
        this.m_tfCascadeName.setName(XMLPATH_GENERAL_CASCADENAME);
        this.m_tfCascadeName.addFocusListener(this);
        this.m_combxCascadeLength = new JComboBox();
        this.m_combxCascadeLength.setVisible(false);
        this.m_combxCascadeLength.setName(XMLPATH_GENERAL_MIN_CASCADELENGTH);
        for (int i = 2; i <= 5; ++i) {
            this.m_combxCascadeLength.addItem(new Integer(i));
        }
        this.m_combxCascadeLength.addItemListener(this);
        this.m_lblCascadeLength = new JLabel("Minimum cascade length");
        this.m_lblCascadeLength.setVisible(false);
        this.m_cbxIgnoreOwnName = new JCheckBox("Ignore own short name");
        this.m_cbxIgnoreOwnName.setName(XMLPATH_GENERAL_MIXNAME);
        this.m_cbxIgnoreOwnName.addItemListener(this);
        this.m_cascadeNameLabel = new JLabel(MSG_CASCADE_NAME);
        this.m_panelGeneralSettings.addRow((Component)this.m_cascadeNameLabel, (Component)this.m_tfCascadeName, this.m_cbxIgnoreOwnName);
        this.initInfoServicesTable(c);
        this.initListenerInterfacesTable(c);
        c.fill = 1;
        c.gridy = 3;
        c.weighty = 1.0;
        this.add((Component)new JLabel(), c);
    }

    private void initInfoServicesTable(GridBagConstraints c) {
        int i;
        this.m_infoServicePanel = new JPanel(new GridBagLayout());
        this.m_infoServicePanel.setBorder(new TitledBorder("Info Services"));
        this.m_infoServicePanel.setToolTipText("Configuration of Info Services");
        c.gridy = 1;
        this.add((Component)this.m_infoServicePanel, c);
        final DefaultTableCellRenderer hostRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                super.setValue(v);
                this.setHorizontalAlignment(0);
            }
        };
        final DefaultTableCellRenderer portRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                int t = (Integer)v;
                if (t <= 0) {
                    super.setValue("");
                } else {
                    this.setHorizontalAlignment(0);
                    super.setValue(v.toString());
                }
            }
        };
        this.m_infoServiceModel = new InfoServiceTableModel();
        this.m_infoServiceModel.addTableModelListener(this);
        this.m_infoServiceTable = new JTable(this.m_infoServiceModel){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                switch (column) {
                    case 0: {
                        return hostRenderer;
                    }
                    case 1: {
                        return portRenderer;
                    }
                }
                return super.getCellRenderer(row, column);
            }
        };
        JScrollPane scrollPane = new JScrollPane(this.m_infoServiceTable, 22, 30);
        this.m_infoServiceTable.setName("Network");
        this.m_infoServiceTable.getTableHeader().setReorderingAllowed(false);
        this.m_infoServiceTable.setSelectionMode(0);
        this.m_infoServiceTable.setPreferredScrollableViewportSize(new Dimension(500, 50));
        this.m_infoServiceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    new InfoServiceDialog(MixConfig.getMainWindow(), "Modify Info Service", GeneralPanel.this.m_infoServiceModel, GeneralPanel.this.m_infoServiceModel.getData(GeneralPanel.this.m_infoServiceTable.getSelectedRow())).setVisible(true);
                }
            }
        });
        int[] columnSizes = new int[]{300, 10};
        for (i = 0; i < columnSizes.length; ++i) {
            TableColumn column = this.m_infoServiceTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(columnSizes[i]);
        }
        i = 0;
        while (i < 3) {
            JButton button;
            switch (i) {
                case 0: {
                    button = new JButton("Add");
                    button.setActionCommand("AddInfoService");
                    button.addActionListener(this);
                    break;
                }
                case 1: {
                    button = new JButton("Delete");
                    this.m_infoServiceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (e.getValueIsAdjusting()) {
                                return;
                            }
                            button.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
                        }
                    });
                    button.setEnabled(false);
                    button.setActionCommand("DeleteInfoService");
                    button.addActionListener(this);
                    break;
                }
                case 2: {
                    button = new JButton("Update");
                    button.setActionCommand(ACTION_UPDATE_IS);
                    button.addActionListener(this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Button should be created.");
                }
            }
            GridBagConstraints ibd = new GridBagConstraints();
            ibd.anchor = 18;
            ibd.insets = new Insets(5, 5, 5, 5);
            ibd.gridx = 1;
            ibd.gridy = i++;
            ibd.fill = 2;
            this.m_infoServicePanel.add((Component)button, ibd);
        }
        GridBagConstraints d = new GridBagConstraints();
        d.anchor = 10;
        d.insets = new Insets(5, 5, 5, 5);
        d.gridx = 0;
        d.gridy = 0;
        d.weightx = 1.0;
        d.weighty = 1.0;
        d.gridheight = 3;
        d.fill = 1;
        this.m_infoServicePanel.add((Component)scrollPane, d);
    }

    private void initListenerInterfacesTable(GridBagConstraints c) {
        this.m_listenerPanel = new JPanel(new GridBagLayout());
        this.m_listenerPanel.setBorder(new TitledBorder("Listener Interfaces"));
        this.m_listenerPanel.setToolTipText("Interfaces the Mix should use for incoming connections (ListenerInterfaces)");
        c.gridy = 2;
        c.fill = 2;
        this.add((Component)this.m_listenerPanel, c);
        final DefaultTableCellRenderer centralRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                super.setValue(v);
                this.setHorizontalAlignment(0);
            }
        };
        final DefaultTableCellRenderer portRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                int t = (Integer)v;
                if (t <= 0) {
                    super.setValue("");
                } else {
                    this.setHorizontalAlignment(0);
                    super.setValue(v.toString());
                }
            }
        };
        final DefaultTableCellRenderer transportRenderer = new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object v) {
                int t = (Integer)v;
                super.setValue(((t & 2) == 0 ? "Raw/" : "SSL/") + ((t & 1) == 0 ? "TCP" : "Unix"));
                this.setHorizontalAlignment(0);
            }
        };
        this.m_listenerModel = new IncomingConnectionTableModel();
        this.m_listenerModel.addTableModelListener(this);
        this.m_listenerTable = new JTable(this.m_listenerModel){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                switch (column) {
                    case 2: {
                        return transportRenderer;
                    }
                    case 4: {
                        return portRenderer;
                    }
                }
                return centralRenderer;
            }
        };
        JScrollPane scrollPane = new JScrollPane(this.m_listenerTable, 22, 30);
        this.m_listenerTable.setName("Network");
        this.m_listenerTable.getTableHeader().setReorderingAllowed(false);
        this.m_listenerTable.setSelectionMode(0);
        this.m_listenerTable.setPreferredScrollableViewportSize(new Dimension(500, 50));
        this.m_listenerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    new IncomingDialog(MixConfig.getMainWindow(), "Change", GeneralPanel.this.m_listenerModel, GeneralPanel.this.m_listenerModel.getData(GeneralPanel.this.m_listenerTable.getSelectedRow()), GeneralPanel.this.getConfiguration().isMixOnCDEnabled()).setVisible(true);
                }
            }
        });
        int[] columnSizes = new int[]{15, 15, 60, 195, 40};
        for (int Index = 0; Index < columnSizes.length; ++Index) {
            TableColumn column = this.m_listenerTable.getColumnModel().getColumn(Index);
            column.setPreferredWidth(columnSizes[Index]);
        }
        int Nr = 0;
        while (Nr < 2) {
            JButton InButton;
            switch (Nr) {
                case 0: {
                    InButton = new JButton("Add");
                    InButton.setActionCommand("AddIncoming");
                    InButton.addActionListener(this);
                    break;
                }
                case 1: {
                    JButton db;
                    InButton = db = new JButton("Delete");
                    this.m_listenerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            if (e.getValueIsAdjusting()) {
                                return;
                            }
                            db.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
                        }
                    });
                    db.setEnabled(false);
                    db.setActionCommand("DeleteIncoming");
                    db.addActionListener(this);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Button should be created.");
                }
            }
            GridBagConstraints ibd = new GridBagConstraints();
            ibd.anchor = 18;
            ibd.insets = new Insets(5, 5, 5, 5);
            ibd.gridx = 1;
            ibd.gridy = Nr++;
            ibd.fill = 2;
            this.m_listenerPanel.add((Component)InButton, ibd);
        }
        GridBagConstraints d = new GridBagConstraints();
        d.anchor = 10;
        d.insets = new Insets(5, 5, 5, 5);
        d.gridx = 0;
        d.gridy = 0;
        d.weightx = 1.0;
        d.weighty = 1.0;
        d.gridheight = 3;
        d.fill = 1;
        this.m_listenerPanel.add((Component)scrollPane, d);
    }

    private boolean isFirstDynamicMix() {
        return this.getConfiguration().getMixType() == 1 && this.getConfiguration().isAutoConfigurationAllowed() && !this.getConfiguration().isFallbackEnabled();
    }

    private void setMixOnCDInfo(boolean a_configuredByMixOnCD) {
        if (a_configuredByMixOnCD) {
            for (int i = 0; i < this.m_listenerModel.getRowCount(); ++i) {
                ConnectionData olddata = this.m_listenerModel.getData(i);
                if (olddata.getTransport() == 1 || olddata.isVirtual()) continue;
                ConnectionData newdata = (ConnectionData)olddata.clone();
                newdata.setHostname(JAPMessages.getString(MixOnCDPanel.MSG_CONFIGURED_BY_MIXONCD));
                this.m_listenerModel.changeData(newdata, olddata);
            }
        } else {
            for (int i = 0; i < this.m_listenerModel.getRowCount(); ++i) {
                ConnectionData olddata = this.m_listenerModel.getData(i);
                if (!olddata.getHostname().equalsIgnoreCase(JAPMessages.getString(MixOnCDPanel.MSG_CONFIGURED_BY_MIXONCD))) continue;
                olddata.setHostname("");
            }
        }
    }

    @Override
    protected void enableComponents() {
        this.m_cbxDynamicFallback.setEnabled(false);
        this.m_lblCascadeLength.setEnabled(this.getConfiguration().isAutoConfigurationAllowed() && this.getConfiguration().getMixType() != 4);
        this.m_combxCascadeLength.setEnabled(this.getConfiguration().isAutoConfigurationAllowed() && this.getConfiguration().getMixType() != 4);
        boolean bEnableCascadeName = this.getConfiguration().getMixType() == 1 && !this.isFirstDynamicMix();
        this.m_tfCascadeName.setEnabled(bEnableCascadeName);
        this.m_cascadeNameLabel.setEnabled(bEnableCascadeName);
        if (this.isFirstDynamicMix()) {
            this.save(this.m_tfCascadeName);
        }
    }

    @Override
    protected void load(JTextField a_textField) {
        super.load(a_textField);
        if (a_textField == this.m_tfCascadeName && a_textField.getText() != null && a_textField.getText().equals(PSEUDO_CASCADE_NAME)) {
            a_textField.setText("");
        }
    }

    @Override
    protected void load(JCheckBox a_cbx) {
        if (a_cbx == this.m_cbxPayment) {
            String sPayment = this.getConfiguration().getAttributeValue(XMLPATH_GENERAL_MIXTYPE, XML_ATTRIBUTE_PAYMENT);
            if (sPayment != null) {
                if (sPayment.equalsIgnoreCase("true")) {
                    this.m_cbxPayment.setSelected(true);
                } else {
                    this.m_cbxPayment.setSelected(false);
                }
            }
        } else if (a_cbx == this.m_cbxIgnoreOwnName) {
            String str = this.getConfiguration().getAttributeValue(a_cbx.getName(), "forCascade");
            if (str != null && (str.equals("Mix") || str.equals("Operator"))) {
                this.m_cbxIgnoreOwnName.setSelected(false);
            } else {
                this.m_cbxIgnoreOwnName.setSelected(true);
            }
        } else {
            super.load(a_cbx);
        }
    }

    @Override
    protected void load(JComboBox a_combx) {
        if (a_combx == this.m_combxConfiguration) {
            if (!this.getConfiguration().isAutoConfigurationAllowed() || this.getConfiguration().isFallbackEnabled()) {
                this.m_cbxDynamicFallback.setSelected(this.getConfiguration().isFallbackEnabled());
                this.m_combxConfiguration.setSelectedItem(JAPMessages.getString(MSG_CONFIGURATION_STATIC));
            } else {
                this.m_combxConfiguration.setSelectedItem(JAPMessages.getString(MSG_CONFIGURATION_DYNAMIC));
            }
        } else if (a_combx == this.m_combxCascadeLength) {
            if (this.getConfiguration().isAutoConfigurationAllowed() && this.getConfiguration().getMixType() != 4) {
                int index;
                try {
                    index = Integer.parseInt(this.getConfiguration().getValue(this.m_combxCascadeLength.getName())) - 2;
                    if (index >= this.m_combxCascadeLength.getItemCount()) {
                        index = this.m_combxCascadeLength.getItemCount() - 1;
                    } else if (index < 0) {
                        index = 0;
                    }
                }
                catch (Exception a_e) {
                    index = 0;
                }
                this.m_combxCascadeLength.setSelectedIndex(index);
            } else {
                this.m_combxCascadeLength.setSelectedIndex(0);
            }
        } else {
            super.load(a_combx);
        }
    }

    @Override
    protected void save(JTextField a_textField) {
        if (a_textField == this.m_tfCascadeName && this.isFirstDynamicMix()) {
            super.save(a_textField.getName(), PSEUDO_CASCADE_NAME);
        } else {
            super.save(a_textField);
        }
    }

    @Override
    protected void save(JCheckBox a_cbx) {
        if (a_cbx == this.m_cbxDynamicFallback) {
            this.getConfiguration().setAttribute(XMLPATH_AUTOCONFIGURATION, XML_ATTRIBUTE_FALLBACK, this.m_cbxDynamicFallback.isSelected());
            this.getConfiguration().setValue(XMLPATH_AUTOCONFIGURATION, this.m_cbxDynamicFallback.isSelected());
        } else if (a_cbx == this.m_cbxPayment) {
            this.getConfiguration().setAttribute(XMLPATH_GENERAL_MIXTYPE, XML_ATTRIBUTE_PAYMENT, this.m_cbxPayment.isSelected());
        } else if (a_cbx == this.m_cbxIgnoreOwnName) {
            if (a_cbx.isSelected()) {
                this.getConfiguration().removeAttribute(a_cbx.getName(), "forCascade");
            } else {
                String str = this.getConfiguration().getAttributeValue(a_cbx.getName(), "forCascade");
                if (str == null || !str.equals("Mix") && !str.equals("Operator")) {
                    this.getConfiguration().setAttribute(a_cbx.getName(), "forCascade", "Mix");
                }
            }
        } else {
            super.save(a_cbx);
        }
    }

    @Override
    protected void save(JComboBox a_combx) {
        if (a_combx == this.m_combxConfiguration) {
            if (a_combx.getSelectedItem().equals(JAPMessages.getString(MSG_CONFIGURATION_STATIC)) && !this.m_cbxDynamicFallback.isSelected()) {
                this.getConfiguration().removeNode(this.m_combxConfiguration.getName());
            } else {
                this.getConfiguration().setValue(this.m_combxConfiguration.getName(), true);
            }
        } else if (a_combx == this.m_combxCascadeLength) {
            if (a_combx.getSelectedIndex() == 0) {
                this.getConfiguration().removeNode(a_combx.getName());
            } else {
                this.getConfiguration().setValue(a_combx.getName(), (Integer)a_combx.getSelectedItem());
            }
        } else {
            super.save(a_combx);
        }
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        super.setConfiguration(a_conf);
        a_conf.addChangeListener(this);
    }

    @Override
    public void load() throws IOException {
        super.load();
        if (this.getConfiguration() != null) {
            this.setMixOnCDInfo(this.getConfiguration().isMixOnCDEnabled());
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.enableComponents();
        if (this.isAutoSaveEnabled()) {
            if (e.getSource() == this.m_infoServiceTable.getModel()) {
                this.save(this.m_infoServiceTable);
            }
            if (e.getSource() == this.m_listenerTable.getModel()) {
                this.save(this.m_listenerTable);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent a_event) {
        String value;
        if (!(a_event instanceof ConfigurationEvent)) {
            return;
        }
        ConfigurationEvent ce = (ConfigurationEvent)a_event;
        if (ce.getModifiedXMLPath().indexOf("MixOnCD") >= 0) {
            this.setMixOnCDInfo(this.getConfiguration().isMixOnCDEnabled());
        } else if (ce.getModifiedXMLPath().equals(XMLPATH_GENERAL_CASCADENAME) && ((value = this.getConfiguration().getValue(XMLPATH_GENERAL_CASCADENAME)) == null || !value.equals(this.m_tfCascadeName.getText()))) {
            this.load(this.m_tfCascadeName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("AddInfoService")) {
            new InfoServiceDialog(MixConfig.getMainWindow(), "Add Info Service", this.m_infoServiceModel).setVisible(true);
        } else if (ae.getActionCommand().equals(ACTION_UPDATE_IS)) {
            Hashtable hashIS = InfoServiceHolder.getInstance().getInfoServices();
            if (hashIS != null && hashIS.size() > 0) {
                Enumeration enumIS = hashIS.elements();
                this.m_infoServiceModel.clear();
                while (enumIS.hasMoreElements()) {
                    InfoServiceDBEntry isEntry = (InfoServiceDBEntry)enumIS.nextElement();
                    Vector vecListeners = isEntry.getListenerInterfaces();
                    ListenerInterface[] nList = new ListenerInterface[vecListeners.size()];
                    for (int i = 0; i < vecListeners.size(); ++i) {
                        nList[i] = (ListenerInterface)vecListeners.elementAt(i);
                    }
                    InfoServiceData isData = new InfoServiceData("InfoService", nList);
                    this.m_infoServiceModel.addData(isData);
                }
            }
        } else if (ae.getActionCommand().equals("DeleteInfoService")) {
            this.m_infoServiceModel.deleteData(this.m_infoServiceTable.getSelectedRow());
        } else if (ae.getActionCommand().equals("AddIncoming")) {
            boolean bEditExisting = false;
            if (this.m_listenerModel.getRowCount() == 1 && this.m_listenerModel.getData(0).getHostname().equals("")) {
                bEditExisting = true;
            }
            if (bEditExisting) {
                new IncomingDialog(MixConfig.getMainWindow(), "Change", this.m_listenerModel, this.m_listenerModel.getData(0), this.getConfiguration().isMixOnCDEnabled()).setVisible(true);
            } else {
                new IncomingDialog(MixConfig.getMainWindow(), "Add", this.m_listenerModel, this.getConfiguration().isMixOnCDEnabled()).setVisible(true);
            }
        } else if (ae.getActionCommand().equals("DeleteIncoming")) {
            this.m_listenerModel.deleteData(this.m_listenerTable.getSelectedRow());
        }
    }

    @Override
    public Vector<String> check() {
        int i;
        int i2;
        int i3;
        Vector<String> errors = new Vector<String>();
        MixConfiguration mixConf = this.getConfiguration();
        try {
            int mixType = this.getConfiguration().getMixType();
            String s = mixConf.getValue(XMLPATH_GENERAL_CASCADENAME);
            if (mixType == 1 && !this.isFirstDynamicMix() && (s == null || s.equals(""))) {
                errors.addElement("Cascade Name not entered.");
            }
        }
        catch (NumberFormatException nfe) {
            errors.addElement("Invalid Mix type in configuration.");
        }
        if (this.m_infoServiceModel.getRowCount() > 0) {
            block2: for (int i4 = 0; i4 < this.m_infoServiceModel.getRowCount(); ++i4) {
                InfoServiceData infoService = this.m_infoServiceModel.getData(i4);
                int noIfaces = infoService.getNumberOfListeners();
                for (int j = 0; j < noIfaces; ++j) {
                    ListenerInterface iface = infoService.getListenerInterface(j);
                    if (!ListenerInterface.isValidHostname(iface.getHost())) {
                        errors.addElement("Invalid host on InfoService " + (i4 + 1) + " (interface " + (j + 1) + ").");
                        if (ListenerInterface.isValidPort(iface.getPort())) continue block2;
                        errors.addElement("Invalid host AND port on InfoService " + (i4 + 1) + " (interface " + (j + 1) + ").");
                        continue block2;
                    }
                    if (!ListenerInterface.isValidPort(iface.getPort())) {
                        errors.addElement("Invalid port on InfoService " + (i4 + 1) + " (interface " + (j + 1) + ").");
                        continue block2;
                    }
                    LogHolder.log(7, LogType.NET, "Interface '" + iface.getHost() + ":" + iface.getPort() + "' found to be valid");
                }
            }
        } else {
            errors.addElement("At least one info service needs to be specified.");
        }
        for (int i5 = 0; i5 < this.m_listenerModel.getRowCount(); ++i5) {
            if (!this.m_listenerModel.getData(i5).getHostname().equals("")) continue;
            errors.addElement("No hostname specified for listener interface " + (i5 + 1) + ".");
            break;
        }
        Vector<Integer> hiddenPorts = new Vector<Integer>();
        Vector<Integer> virtualPorts = new Vector<Integer>();
        for (i3 = 0; i3 < this.m_listenerModel.getRowCount(); ++i3) {
            if (this.m_listenerModel.getData(i3).isVirtual()) {
                virtualPorts.addElement(new Integer(this.m_listenerModel.getData(i3).getPort()));
            }
            if (!this.m_listenerModel.getData(i3).isHidden()) continue;
            hiddenPorts.addElement(new Integer(this.m_listenerModel.getData(i3).getPort()));
        }
        for (i3 = 0; i3 < virtualPorts.size(); ++i3) {
            if (hiddenPorts.contains(virtualPorts.elementAt(i3))) continue;
            errors.addElement("No corresponding hidden interface for port " + (Integer)virtualPorts.elementAt(i3) + ".");
        }
        for (i3 = 0; i3 < hiddenPorts.size(); ++i3) {
            if (virtualPorts.contains(hiddenPorts.elementAt(i3))) continue;
            errors.addElement("No corresponding virtual interface for port " + (Integer)hiddenPorts.elementAt(i3) + ".");
        }
        Vector<Integer> defaultPorts = new Vector<Integer>();
        for (i2 = 0; i2 < this.m_listenerModel.getRowCount(); ++i2) {
            if (this.m_listenerModel.getData(i2).isVirtual() || this.m_listenerModel.getData(i2).isHidden()) continue;
            defaultPorts.addElement(new Integer(this.m_listenerModel.getData(i2).getPort()));
        }
        for (i2 = 0; i2 < virtualPorts.size(); ++i2) {
            if (!defaultPorts.contains(virtualPorts.elementAt(i2))) continue;
            errors.addElement("A virtual interface conflicts with a default interface on port " + (Integer)virtualPorts.elementAt(i2) + ".");
        }
        for (i2 = 0; i2 < hiddenPorts.size(); ++i2) {
            if (!defaultPorts.contains(hiddenPorts.elementAt(i2))) continue;
            errors.addElement("A hidden interface is conflicting with a default interface on port " + (Integer)hiddenPorts.elementAt(i2) + ".");
        }
        Vector<Integer> failedDefaultPorts = new Vector<Integer>();
        for (i = 0; i < defaultPorts.size(); ++i) {
            Integer port = (Integer)defaultPorts.elementAt(i);
            for (int j = 0; j < defaultPorts.size(); ++j) {
                if (i == j || !((Integer)defaultPorts.elementAt(j)).equals(port) || failedDefaultPorts.contains(port)) continue;
                errors.addElement("There is more than one default interface for port " + port + ".");
                failedDefaultPorts.addElement(port);
            }
        }
        for (i = 0; i < this.m_listenerModel.getRowCount(); ++i) {
            int port = this.m_listenerModel.getData(i).getPort();
            if (port != 0 || this.m_listenerModel.getData(i).getTransport() == 1) continue;
            errors.addElement("No port specified for listener interface " + (i + 1) + ".");
            break;
        }
        if (this.m_listenerModel.getRowCount() == 0) {
            errors.addElement("No listener interfaces specified.");
        }
        if (this.m_listenerModel.getRowCount() > 0) {
            boolean ok = false;
            for (int i6 = 0; i6 < this.m_listenerModel.getRowCount(); ++i6) {
                if (this.m_listenerModel.getData(i6).isVirtual()) continue;
                ok = true;
            }
            if (!ok) {
                errors.addElement("No non-virtual listener interfaces specified.");
            }
        }
        boolean autoconf = this.m_listenerModel.getRowCount() == 0;
        boolean hidden = false;
        boolean virtual = false;
        if (!autoconf) {
            for (int i7 = 0; i7 < this.m_listenerModel.getRowCount(); ++i7) {
                virtual = this.m_listenerModel.getData(i7).isVirtual();
                hidden = this.m_listenerModel.getData(i7).isHidden();
                if (hidden || virtual) continue;
                autoconf = true;
                break;
            }
            if (this.getConfiguration().isAutoConfigurationAllowed() && !autoconf) {
                errors.addElement("Autoconfiguration is not possible, if all listener interfaces are set to hidden or virtual. Add at least one non-hidden, non-virtual interface to enable autoconfiguration.");
            }
        }
        return errors;
    }

    @Override
    public String getHelpContext() {
        return this.getClass().getName();
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

