/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import javax.swing.table.AbstractTableModel;
import mixconfig.network.ConnectionData;

public abstract class ConnectionTableModel
extends AbstractTableModel {
    private ConnectionData[] rows = new ConnectionData[0];
    public static final int NR = 0;
    public static final int TYPE = 1;
    public static final int TRANSPORT = 2;
    public static final int HOST = 3;
    public static final int PORT = 4;
    public static final int VISIBLE = 5;

    @Override
    public int getRowCount() {
        return this.rows.length;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addData(ConnectionData data) {
        ConnectionData[] nrows = new ConnectionData[this.rows.length + 1];
        for (int i = 0; i < this.rows.length; ++i) {
            nrows[i] = this.rows[i];
        }
        nrows[this.rows.length] = data;
        this.rows = nrows;
        this.fireTableRowsInserted(this.rows.length - 1, this.rows.length - 1);
    }

    public ConnectionData getData(int index) {
        if (index < 0 || index >= this.rows.length) {
            return null;
        }
        return this.rows[index];
    }

    public void changeData(ConnectionData data, ConnectionData olddata) {
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i] != olddata) continue;
            this.rows[i] = data;
            this.fireTableRowsUpdated(i, i);
            return;
        }
        this.addData(data);
    }

    public void deleteData(int index) {
        if (index >= 0 && index < this.rows.length) {
            int i;
            ConnectionData[] nrows = new ConnectionData[this.rows.length - 1];
            for (i = 0; i < index; ++i) {
                nrows[i] = this.rows[i];
            }
            for (i = index + 1; i < this.rows.length; ++i) {
                nrows[i - 1] = this.rows[i];
            }
            this.rows = nrows;
            this.fireTableRowsDeleted(index, index);
        }
    }

    void clear() {
        int old = this.rows.length;
        this.rows = new ConnectionData[0];
        this.fireTableRowsDeleted(1, old);
    }
}

