/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.infoservice;

import gui.JAPJIntField;
import gui.MixConfigTextField;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mixconfig.infoservice.InfoServiceData;
import mixconfig.infoservice.InfoServiceTableModel;

public class InfoServiceDialog
extends JAPDialog {
    private MixConfigTextField m_tfHost;
    private JAPJIntField m_tfPort;
    private JLabel m_lblHost;
    private JLabel m_lblPort;
    protected final ActionListener nextFocusAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocus();
        }
    };

    public InfoServiceDialog(Frame parent, String title, InfoServiceTableModel model) {
        super(parent, title);
        this.createDialog(null, model);
    }

    public InfoServiceDialog(Frame parent, String title, InfoServiceTableModel model, InfoServiceData data) {
        super(parent, title);
        this.createDialog(data, model);
    }

    protected String getType() {
        return "InfoService";
    }

    protected InfoServiceData getData() {
        return new InfoServiceData(this.getType(), this.m_tfHost.getText().trim(), this.m_tfPort.getInt());
    }

    private void createDialog(InfoServiceData data, InfoServiceTableModel where) {
        this.setSize(500, 350);
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 17;
        lc.insets = new Insets(5, 5, 5, 5);
        lc.gridx = 0;
        lc.gridy = 0;
        lc.weightx = 1.0;
        GridBagConstraints rc = new GridBagConstraints();
        rc.anchor = 17;
        rc.insets = new Insets(5, 5, 5, 5);
        rc.gridx = 1;
        rc.gridy = 0;
        rc.weightx = 0.0;
        this.addHost(data, layout, lc, rc);
        this.addPort(data, layout, lc, rc);
        this.addKeys(data, where, layout, lc, rc);
        this.setResizable(false);
        this.pack();
    }

    protected void addHost(InfoServiceData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        this.m_lblHost = new JLabel("Host");
        layout.setConstraints(this.m_lblHost, lc);
        this.getContentPane().add(this.m_lblHost);
        ++lc.gridy;
        rc.anchor = 17;
        rc.gridwidth = 7;
        this.m_tfHost = data == null ? new MixConfigTextField(20) : new MixConfigTextField(data.getListenerInterface(0).getHost(), 20);
        this.m_tfHost.setMinimumSize(this.m_tfHost.getPreferredSize());
        layout.setConstraints(this.m_tfHost, rc);
        this.getContentPane().add(this.m_tfHost);
        this.m_tfHost.addActionListener(this.nextFocusAction);
        ++rc.gridy;
    }

    protected void addPort(InfoServiceData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        this.m_lblPort = new JLabel("Port");
        layout.setConstraints(this.m_lblPort, lc);
        this.getContentPane().add(this.m_lblPort);
        ++lc.gridy;
        rc.gridwidth = 7;
        this.m_tfPort = new JAPJIntField(65535, true);
        this.m_tfPort.setMinimumSize(this.m_tfPort.getPreferredSize());
        if (data != null) {
            this.m_tfPort.setInt(data.getListenerInterface(0).getPort());
        } else {
            this.m_tfPort.setInt(80);
        }
        layout.setConstraints(this.m_tfPort, rc);
        this.getContentPane().add(this.m_tfPort);
        this.m_tfPort.addActionListener(this.nextFocusAction);
        ++rc.gridy;
    }

    protected void addKeys(final InfoServiceData data, final InfoServiceTableModel model, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        JButton key;
        GridBagLayout keyLayout = new GridBagLayout();
        JPanel keys = new JPanel(keyLayout);
        GridBagConstraints kc = new GridBagConstraints();
        kc.weightx = 1.0;
        kc.gridx = 0;
        kc.gridy = 0;
        kc.gridwidth = 1;
        kc.fill = 2;
        kc.insets = new Insets(1, 1, 1, 1);
        if (data == null) {
            key = new JButton("Add");
            key.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (!InfoServiceDialog.this.m_tfHost.getText().equals("") && !InfoServiceDialog.this.m_tfPort.getText().equals("")) {
                        model.addData(InfoServiceDialog.this.getData());
                        InfoServiceDialog.this.dispose();
                    }
                }
            });
        } else {
            key = new JButton("Apply");
            key.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (!InfoServiceDialog.this.m_tfHost.getText().equals("") && !InfoServiceDialog.this.m_tfPort.getText().equals("")) {
                        model.changeData(InfoServiceDialog.this.getData(), data);
                        InfoServiceDialog.this.dispose();
                    }
                }
            });
        }
        key.setActionCommand("Ok");
        keyLayout.setConstraints(key, kc);
        keys.add(key);
        ++kc.gridx;
        key = new JButton("Cancel");
        key.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                InfoServiceDialog.this.dispose();
            }
        });
        keyLayout.setConstraints(key, kc);
        keys.add(key);
        lc.gridwidth = 8;
        lc.fill = 2;
        layout.setConstraints(keys, lc);
        this.getContentPane().add(keys);
        ++lc.gridy;
        ++rc.gridy;
    }
}

