/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import gui.dialog.JAPDialog;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import mixconfig.ConfigFrame;
import mixconfig.Menu;
import mixconfig.MixConfig;
import mixconfig.panels.StartScreenPanel;
import mixconfig.wizard.ConfigWizard;

public class ChoicePanel
extends JPanel {
    public static final Dimension DEFAULT_SIZE = new Dimension(785, 600);
    public static final String CARD_WIZ = "card_mainPanel_wiz";
    public static final String CARD_EXPERT = "card_mainPanel_expert";
    public static final String CARD_CHOICE = "card_choicePanel";
    public static final String WIZARD = "wizard";
    public static final String EXPERT = "expert";
    public static final String START = "start";
    private String activeCard = "start";
    private static StartScreenPanel m_startScreenPanel;
    private static ConfigWizard m_mainPanel_wiz;
    private static ConfigFrame m_mainPanel_expert;
    private Menu m_menu;
    private JFrame m_Parent;
    private CardLayout m_cardLayout;

    public ChoicePanel(JFrame parent, JRootPane rootPane) {
        this(parent, rootPane, CARD_CHOICE);
    }

    public ChoicePanel(JFrame parent, JRootPane rootPane, String startPanel) {
        String panelToStart = startPanel;
        if (panelToStart.equals(CARD_WIZ)) {
            this.activeCard = WIZARD;
        } else if (panelToStart.equals(CARD_EXPERT)) {
            this.activeCard = EXPERT;
        } else {
            panelToStart = CARD_CHOICE;
            this.activeCard = START;
        }
        this.setDefaultSize();
        this.m_Parent = parent;
        if (this.m_Parent != null) {
            this.m_Parent.setResizable(true);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                ChoicePanel component = (ChoicePanel)event.getComponent();
                if (component.getWidth() < ChoicePanel.DEFAULT_SIZE.width || component.getHeight() < ChoicePanel.DEFAULT_SIZE.height) {
                    component.setDefaultSize();
                }
            }
        });
        this.m_cardLayout = new CardLayout();
        this.setLayout(this.m_cardLayout);
        try {
            m_startScreenPanel = new StartScreenPanel(this);
            m_mainPanel_wiz = new ConfigWizard();
            m_mainPanel_expert = new ConfigFrame(this.m_Parent);
            this.add((Component)m_startScreenPanel, CARD_CHOICE);
            this.add((Component)m_mainPanel_wiz, CARD_WIZ);
            this.add((Component)m_mainPanel_expert, CARD_EXPERT);
            this.m_cardLayout.show(this, panelToStart);
            this.m_menu = new Menu(parent, rootPane, m_mainPanel_wiz, m_mainPanel_expert);
        }
        catch (Exception e) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)e);
        }
    }

    protected String getActiveCard() {
        return this.activeCard;
    }

    public void setWizardVisible() {
        this.m_cardLayout.show(this, CARD_WIZ);
        this.activeCard = WIZARD;
        this.m_menu.checkUnuseableMenuItem();
        this.setMessageTitle();
    }

    protected void setExpertVisible() {
        this.m_cardLayout.show(this, CARD_EXPERT);
        this.activeCard = EXPERT;
        this.m_menu.checkUnuseableMenuItem();
        this.setMessageTitle();
    }

    public void setStartScreenVisible() {
        this.m_cardLayout.show(this, CARD_CHOICE);
        this.activeCard = START;
        this.m_menu.checkUnuseableMenuItem();
        this.setMessageTitle();
    }

    public Menu getMenu() {
        return this.m_menu;
    }

    public void setDefaultSize() {
        this.setSize(DEFAULT_SIZE);
        this.setMinimumSize(DEFAULT_SIZE);
        this.setPreferredSize(DEFAULT_SIZE);
        if (this.m_Parent != null) {
            Point location = this.m_Parent.getLocation();
            this.m_Parent.pack();
            this.m_Parent.setLocation(location);
        }
    }

    public void setMessageTitle() {
        try {
            JFrame parentFrame = (JFrame)m_mainPanel_wiz.getRootPane().getParent();
            int max = m_mainPanel_wiz.getPageCount();
            int current = m_mainPanel_wiz.getCurrentPageNr() + 1;
            if (this.getActiveCard().equals(WIZARD)) {
                String newTitle = "(" + String.valueOf(current) + "/" + String.valueOf(max) + ")";
                newTitle = "Mix Configuration Tool Wizard " + newTitle;
                parentFrame.setTitle(newTitle);
            } else if (this.getActiveCard().equals(EXPERT)) {
                parentFrame.setTitle("Mix Configuration Tool");
            } else if (this.getActiveCard().equals(START)) {
                parentFrame.setTitle("Mix Configuration Tool");
            }
            if (MixConfig.getCurrentFileName() != null) {
                String currentTitle = parentFrame.getTitle();
                parentFrame.setTitle(currentTitle + " - " + MixConfig.getCurrentFileName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

