/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.platform.AbstractOS;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import logging.LogHolder;
import logging.LogType;

public class LinkMouseListener
extends MouseAdapter {
    private ILinkGenerator m_linkToOpen = null;
    private ILinkCallback m_callback;

    public LinkMouseListener() {
    }

    public LinkMouseListener(String a_Link) {
        this(a_Link, null);
    }

    public LinkMouseListener(String a_Link, ILinkCallback a_callback) {
        this.m_callback = a_callback;
        this.m_linkToOpen = new ImmutableLinkGenerator(a_Link);
    }

    public LinkMouseListener(ILinkGenerator a_Link) {
        this.m_linkToOpen = a_Link;
    }

    public void mouseClicked(MouseEvent e) {
        String linkText;
        if (this.m_linkToOpen != null) {
            linkText = this.m_linkToOpen.createLink();
        } else if (e.getSource() instanceof JLabel) {
            linkText = ((JLabel)e.getSource()).getText();
        } else {
            return;
        }
        try {
            URL linkUrl = new URL(linkText);
            if (this.m_callback != null) {
                this.m_callback.callback(linkUrl);
            }
            AbstractOS.getInstance().openURL(linkUrl);
        }
        catch (ClassCastException cce) {
            LogHolder.log(3, LogType.PAY, "opening a link failed, reason: called on non-JLabel component");
        }
        catch (MalformedURLException mue) {
            LogHolder.log(3, LogType.PAY, "opening a link failed, reason: malformed URL");
        }
    }

    public void mouseEntered(MouseEvent e) {
        JComponent source = (JComponent)e.getSource();
        source.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent e) {
        JComponent source = (JComponent)e.getSource();
        source.setCursor(Cursor.getPredefinedCursor(0));
    }

    private class ImmutableLinkGenerator
    implements ILinkGenerator {
        private String m_LinkToOpen;

        public ImmutableLinkGenerator(String a_LinkToOpen) {
            this.m_LinkToOpen = a_LinkToOpen;
        }

        public String createLink() {
            return this.m_LinkToOpen;
        }
    }

    public static interface ILinkGenerator {
        public String createLink();
    }

    public static interface ILinkCallback {
        public void callback(URL var1);
    }
}

