/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.util.JAPMessages;
import anon.util.captcha.IImageEncodedCaptcha;
import anon.util.captcha.MyImage;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import logging.LogHolder;
import logging.LogType;

public class CaptchaDialog
extends JAPDialog
implements ActionListener {
    private static final String MSG_TITLE = (class$gui$CaptchaDialog == null ? (class$gui$CaptchaDialog = CaptchaDialog.class$("gui.CaptchaDialog")) : class$gui$CaptchaDialog).getName() + "_title";
    private static final String MSG_SOLVE = (class$gui$CaptchaDialog == null ? (class$gui$CaptchaDialog = CaptchaDialog.class$("gui.CaptchaDialog")) : class$gui$CaptchaDialog).getName() + "_solve";
    private static final String MSG_OK = (class$gui$CaptchaDialog == null ? (class$gui$CaptchaDialog = CaptchaDialog.class$("gui.CaptchaDialog")) : class$gui$CaptchaDialog).getName() + "_ok";
    private static final String MSG_CANCEL = (class$gui$CaptchaDialog == null ? (class$gui$CaptchaDialog = CaptchaDialog.class$("gui.CaptchaDialog")) : class$gui$CaptchaDialog).getName() + "_cancel";
    private static final String MSG_WRONGCHARNUM = (class$gui$CaptchaDialog == null ? (class$gui$CaptchaDialog = CaptchaDialog.class$("gui.CaptchaDialog")) : class$gui$CaptchaDialog).getName() + "_wrongcharnum";
    private JTextField m_tfSolution;
    private JButton m_btnOk;
    private JButton m_btnCancel;
    private byte[] m_solution;
    private IImageEncodedCaptcha m_captcha;
    private String m_beginsWith;
    static /* synthetic */ Class class$gui$CaptchaDialog;

    public CaptchaDialog(IImageEncodedCaptcha a_captcha, String a_beginsWith, Window a_parent) {
        super(a_parent, JAPMessages.getString(MSG_TITLE), true);
        this.m_captcha = a_captcha;
        this.m_beginsWith = a_beginsWith;
        Container rootPanel = this.getContentPane();
        GridBagConstraints c = new GridBagConstraints();
        rootPanel.setLayout(new GridBagLayout());
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 0;
        c.gridy = 0;
        c.gridx = 0;
        MyImage myImg = a_captcha.getImage();
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(myImg.getWidth(), myImg.getHeight(), myImg.getPixels(), 0, myImg.getWidth()));
        JLabel image = new JLabel(new ImageIcon(img));
        rootPanel.add((Component)image, c);
        ++c.gridy;
        JLabel l = new JLabel("<html>" + JAPMessages.getString(MSG_SOLVE) + "</html>");
        rootPanel.add((Component)l, c);
        ++c.gridy;
        final IImageEncodedCaptcha captcha = a_captcha;
        this.m_tfSolution = new JTextField(20){

            protected Document createDefaultModel() {
                return new PlainDocument(){

                    public void insertString(int a_position, String a_stringToInsert, AttributeSet a_attributes) throws BadLocationException {
                        if (this.getLength() + a_stringToInsert.length() <= captcha.getCharacterNumber()) {
                            boolean invalidCharacters = false;
                            for (int i = 0; i < a_stringToInsert.length() && !invalidCharacters; ++i) {
                                if (captcha.getCharacterSet().indexOf(a_stringToInsert.toUpperCase().substring(i, i + 1)) >= 0) continue;
                                invalidCharacters = true;
                            }
                            if (!invalidCharacters) {
                                super.insertString(a_position, a_stringToInsert.toUpperCase(), a_attributes);
                            }
                        }
                    }
                };
            }
        };
        rootPanel.add((Component)this.m_tfSolution, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.m_btnCancel = new JButton(JAPMessages.getString(MSG_CANCEL));
        this.m_btnCancel.addActionListener(this);
        rootPanel.add((Component)this.m_btnCancel, c);
        ++c.gridx;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.m_btnOk = new JButton(JAPMessages.getString(MSG_OK));
        this.m_btnOk.addActionListener(this);
        rootPanel.add((Component)this.m_btnOk, c);
        this.pack();
        this.setLocationRelativeTo(this.getOwner(), 0);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent a_e) {
        Object source = a_e.getSource();
        if (source == this.m_btnCancel) {
            this.dispose();
        } else if (source == this.m_btnOk) {
            if (this.m_captcha.getCharacterNumber() == this.m_tfSolution.getText().length()) {
                try {
                    this.m_solution = this.m_captcha.solveCaptcha(this.m_tfSolution.getText().trim(), this.m_beginsWith.getBytes());
                    this.dispose();
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.MISC, "Error solving captcha!");
                }
            } else {
                JAPDialog.showErrorDialog((JAPDialog)this, JAPMessages.getString(MSG_WRONGCHARNUM) + " " + this.m_captcha.getCharacterNumber() + ".");
            }
        }
    }

    public byte[] getSolution() {
        return this.m_solution;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

