/*
 * Decompiled with CFR 0.152.
 */
package anon.platform;

import anon.infoservice.ListenerInterface;
import anon.infoservice.ProxyInterface;
import anon.platform.AbstractOS;
import anon.platform.WindowsRegistry;
import anon.util.IPasswordReader;
import anon.util.RecursiveFileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.StringTokenizer;
import logging.LogHolder;
import logging.LogType;

public final class WindowsOS
extends AbstractOS {
    static /* synthetic */ Class class$java$io$File;

    public WindowsOS() throws Exception {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.indexOf("win") == -1) {
            throw new Exception("Operating system is not Windows");
        }
        if (osName.indexOf("windows 9") > -1) {
            this.initEnv("command.com /c set");
        } else {
            this.initEnv("cmd.exe /c set");
        }
        LogHolder.log(7, LogType.MISC, "platform.WindowsOS instantiated.");
    }

    protected final boolean openLink(String a_link) {
        return this.execute("rundll32 url.dll,FileProtocolHandler " + a_link);
    }

    protected String getAsString(URL a_url) {
        if (a_url == null) {
            return null;
        }
        String strURL = super.getAsString(a_url);
        if (new StringTokenizer(strURL).countTokens() > 1) {
            return "\"" + strURL + "\"";
        }
        return strURL;
    }

    public boolean isHelpAutoInstalled() {
        return true;
    }

    public String getDefaultHelpPath(String a_applicationName) {
        String dir = this.getAppdataDefaultDirectory(a_applicationName, true);
        if (dir == null) {
            dir = super.getDefaultHelpPath(a_applicationName);
        }
        return dir;
    }

    public String getConfigPath(String a_applicationName, boolean a_bCreate) {
        String vendor = System.getProperty("java.vendor", "unknown");
        String dir = "";
        if (vendor.trim().toLowerCase().startsWith("microsoft")) {
            try {
                String line;
                BufferedReader winPropertiesReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("CMD /C SET").getInputStream()));
                while ((line = winPropertiesReader.readLine()) != null && !line.startsWith("USERPROFILE")) {
                }
                if (line != null) {
                    StringTokenizer tokenizer = new StringTokenizer(line, "=");
                    tokenizer.nextToken();
                    dir = tokenizer.nextToken().trim();
                }
            }
            catch (Exception a_e) {
                // empty catch block
            }
            if (dir == null) {
                dir = System.getProperty("user.dir");
            }
        } else {
            dir = this.getAppdataDefaultDirectory(a_applicationName, a_bCreate);
            if (dir == null) {
                dir = System.getProperty("user.home");
            }
        }
        if (dir == null) {
            return "";
        }
        return dir + File.separator;
    }

    public String getAppdataDefaultDirectory(String a_applicationName, boolean a_bCreate) {
        return this.getEnvPath(a_applicationName, "APPDATA", a_bCreate);
    }

    public boolean copyAsRoot(File a_sourceFile, File a_targetDirectory, AbstractOS.AbstractRetryCopyProcess a_checkRetry) {
        try {
            long lastSize;
            byte[] md5OldFile;
            Class<?> c = Class.forName("gui.JAPDll");
            Class[] arArgClasses = new Class[]{class$java$io$File == null ? (class$java$io$File = WindowsOS.class$("java.io.File")) : class$java$io$File, class$java$io$File == null ? (class$java$io$File = WindowsOS.class$("java.io.File")) : class$java$io$File, Boolean.TYPE};
            Method methodXcopy = c.getMethod("xcopy", arArgClasses);
            Object[] args = new Object[]{a_sourceFile, a_targetDirectory, Boolean.TRUE};
            File fileToCopy = new File(a_targetDirectory.getPath() + File.separator + a_sourceFile.getName());
            long sizeSource = RecursiveFileTool.getFileSize(a_sourceFile);
            long sizeOldFile = fileToCopy.length();
            try {
                md5OldFile = RecursiveFileTool.createMD5Digest(fileToCopy);
            }
            catch (Exception a_e) {
                LogHolder.log(2, LogType.MISC, a_e);
                md5OldFile = null;
            }
            boolean ret = (Boolean)methodXcopy.invoke(null, args);
            boolean bChanceToRetry = false;
            if (!ret) {
                if (a_checkRetry != null && a_checkRetry.checkRetry()) {
                    return this.copyAsRoot(a_sourceFile, a_targetDirectory, a_checkRetry);
                }
                LogHolder.log(3, LogType.MISC, "Root copy failed!");
                return false;
            }
            if (a_checkRetry == null || a_checkRetry.getMaxProgressSteps() <= 0) {
                return true;
            }
            long currentSize = lastSize = (long)(-1 * a_checkRetry.getMaxProgressSteps());
            while (a_checkRetry.incrementProgress()) {
                try {
                    currentSize = currentSize > 0L || !RecursiveFileTool.equals(fileToCopy, md5OldFile, sizeOldFile) ? RecursiveFileTool.getFileSize(fileToCopy) : ++currentSize;
                    if (currentSize == sizeSource) {
                        if (RecursiveFileTool.equals(fileToCopy, a_sourceFile, true)) {
                            while (a_checkRetry.incrementProgress()) {
                            }
                            return true;
                        }
                        LogHolder.log(3, LogType.MISC, "Root copy failed!");
                        bChanceToRetry = true;
                        break;
                    }
                    if ((a_checkRetry.getCurrentStep() > 1 || a_checkRetry.getMaxProgressSteps() == 1) && currentSize <= lastSize) {
                        LogHolder.log(3, LogType.MISC, "Root copy failed!");
                        bChanceToRetry = true;
                        break;
                    }
                    lastSize = currentSize;
                }
                catch (SecurityException a_e) {
                    LogHolder.log(3, LogType.MISC, a_e);
                    bChanceToRetry = true;
                    break;
                }
                Thread.sleep(a_checkRetry.getProgressLoopWaitMilliseconds());
                Thread.yield();
            }
            if (RecursiveFileTool.equals(fileToCopy, a_sourceFile, true)) {
                return true;
            }
            if (bChanceToRetry && a_checkRetry.checkRetry()) {
                a_checkRetry.reset();
                return this.copyAsRoot(a_sourceFile, a_targetDirectory, a_checkRetry);
            }
        }
        catch (Throwable t) {
            LogHolder.log(2, LogType.MISC, t);
        }
        return false;
    }

    public ProxyInterface getProxyInterface(IPasswordReader a_passwordReader) {
        WindowsRegistry registry = null;
        String strInterface = null;
        boolean bSocks = false;
        try {
            registry = new WindowsRegistry(-2147483647, "Software/Microsoft/Windows/CurrentVersion/Internet Settings", 131097);
            String strSettings = registry.read("ProxyServer");
            if (strSettings != null) {
                StringTokenizer tokenizer = new StringTokenizer(strSettings, ";");
                while (tokenizer.hasMoreTokens() && (strInterface = tokenizer.nextToken()).toLowerCase().startsWith("socks=")) {
                }
            }
            if (strInterface == null) {
                return null;
            }
            if (strInterface != null && strInterface.indexOf("=") > 0) {
                if (strInterface.toLowerCase().startsWith("socks=")) {
                    bSocks = true;
                }
                strInterface = strInterface.substring(strInterface.indexOf("=") + 1, strInterface.length());
            }
            ProxyInterface proxyInterface = new ProxyInterface(ListenerInterface.parseHostnamePort(strSettings, bSocks ? 3 : 1), a_passwordReader);
            registry.close();
            return proxyInterface;
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "Could not get proxy registry settings...", e);
            return null;
        }
    }

    public String getTempPath() {
        String tempDir = super.getTempPath();
        if (tempDir == null) {
            tempDir = this.getenv("TEMP");
        }
        if (tempDir == null) {
            tempDir = this.getenv("TMP");
        }
        if (tempDir != null && !tempDir.endsWith(File.separator)) {
            tempDir = tempDir + File.separator;
        }
        return tempDir;
    }

    private String getEnvPath(String a_applicationName, String a_envPath, boolean a_bCreate) {
        if (a_applicationName == null) {
            throw new IllegalArgumentException("Application name is null!");
        }
        String path = null;
        path = this.getenv(a_envPath);
        if (path != null && path.trim().length() > 0 && new File(path).exists()) {
            File directory = new File((path = path + File.separator + a_applicationName) + File.separator);
            if (!(directory.exists() || a_bCreate && directory.mkdir())) {
                if (a_bCreate) {
                    LogHolder.log(3, LogType.MISC, "Could not create storage directory: " + path);
                }
                path = null;
            }
        } else {
            path = null;
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

