/*
 * Decompiled with CFR 0.152.
 */
package anon.platform;

import anon.infoservice.ProxyInterface;
import anon.platform.VMPerfDataFile;
import anon.util.ClassUtil;
import anon.util.IPasswordReader;
import anon.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractOS {
    public static final String URL_MAIL_TO = "mailto:";
    private static Class[] REGISTERED_PLATFORM_CLASSES = new Class[]{class$anon$platform$AndroidOS == null ? (class$anon$platform$AndroidOS = AbstractOS.class$("anon.platform.AndroidOS")) : class$anon$platform$AndroidOS, class$anon$platform$LinuxOS == null ? (class$anon$platform$LinuxOS = AbstractOS.class$("anon.platform.LinuxOS")) : class$anon$platform$LinuxOS, class$anon$platform$WindowsOS == null ? (class$anon$platform$WindowsOS = AbstractOS.class$("anon.platform.WindowsOS")) : class$anon$platform$WindowsOS, class$anon$platform$MacOS == null ? (class$anon$platform$MacOS = AbstractOS.class$("anon.platform.MacOS")) : class$anon$platform$MacOS, class$anon$platform$UnknownOS == null ? (class$anon$platform$UnknownOS = AbstractOS.class$("anon.platform.UnknownOS")) : class$anon$platform$UnknownOS};
    private static final String[] BROWSERLIST = new String[]{"firefox", "mozilla-firefox", "chrome", "opera", "mozilla", "iexplore", "explorer", "konqueror"};
    private static final String WHITESPACE_ENCODED = "%20";
    private static AbstractOS ms_operatingSystem;
    private IURLErrorNotifier m_notifier;
    private AbstractURLOpener m_URLOpener;
    private Properties m_envVars;
    private static File ms_tmpDir;
    private static int ms_iJavaWebstart;
    static /* synthetic */ Class class$anon$platform$AndroidOS;
    static /* synthetic */ Class class$anon$platform$LinuxOS;
    static /* synthetic */ Class class$anon$platform$WindowsOS;
    static /* synthetic */ Class class$anon$platform$MacOS;
    static /* synthetic */ Class class$anon$platform$UnknownOS;

    public static final synchronized AbstractOS getInstance() {
        for (int i = 0; ms_operatingSystem == null && i < REGISTERED_PLATFORM_CLASSES.length; ++i) {
            try {
                ms_operatingSystem = (AbstractOS)REGISTERED_PLATFORM_CLASSES[i].newInstance();
            }
            catch (Exception a_e) {
                LogHolder.log(7, LogType.MISC, "Cannot instantiate class " + REGISTERED_PLATFORM_CLASSES[i] + ". Trying to instanciate another platform class.");
            }
            if (ms_operatingSystem == null) continue;
            AbstractOS.ms_operatingSystem.m_notifier = new IURLErrorNotifier(){

                public void checkNotify(URL a_url) {
                }
            };
        }
        return ms_operatingSystem;
    }

    public static String createBrowserCommand(String pFFExecutable) {
        pFFExecutable = Util.replaceAll(pFFExecutable, "/", File.separator);
        StringBuffer pFFExecutableBuf = new StringBuffer("");
        int whiteSpEnc = pFFExecutable.indexOf(WHITESPACE_ENCODED, 0);
        int lastIx = 0;
        while (whiteSpEnc != -1) {
            pFFExecutableBuf.append(pFFExecutable.substring(lastIx, whiteSpEnc));
            pFFExecutableBuf.append(" ");
            lastIx = whiteSpEnc + WHITESPACE_ENCODED.length();
            whiteSpEnc = pFFExecutable.indexOf(WHITESPACE_ENCODED, whiteSpEnc + 1);
        }
        pFFExecutableBuf.append(pFFExecutable.substring(lastIx));
        pFFExecutable = AbstractOS.toAbsolutePath(pFFExecutableBuf.toString());
        return pFFExecutable;
    }

    public static String toRelativePath(String a_path) {
        if (a_path == null) {
            return null;
        }
        String strUserDir = System.getProperty("user.dir");
        String strRelative = "";
        if (a_path.substring(1, 3).equals(":\\") && !strUserDir.substring(0, 3).equals(a_path.substring(0, 3))) {
            return a_path;
        }
        if (strUserDir.endsWith(File.separator)) {
            strUserDir = strUserDir.substring(0, strUserDir.lastIndexOf(File.separator));
        }
        while (true) {
            if (strUserDir.length() == 0 || a_path.indexOf(strUserDir) == 0) {
                if ((a_path = a_path.substring(strUserDir.length(), a_path.length())).startsWith(File.separator)) {
                    a_path = a_path.substring(a_path.indexOf(File.separator) + 1, a_path.length());
                }
                break;
            }
            int index = strUserDir.lastIndexOf(File.separator);
            if (index >= 0) {
                strUserDir = strUserDir.substring(0, index);
                strRelative = strRelative + ".." + File.separator;
                continue;
            }
            strUserDir = "";
        }
        a_path = strRelative + a_path;
        return a_path;
    }

    public static String toAbsolutePath(String path) {
        if (path != null) {
            if (File.separator.equals("\\") && !path.startsWith(File.separator) && path.length() >= 3 && !path.substring(1, 3).equals(":" + File.separator) || File.separator.equals("/") && !path.startsWith(File.separator)) {
                return System.getProperty("user.dir") + File.separator + path;
            }
            return path;
        }
        return null;
    }

    public void init(IURLErrorNotifier a_notifier, AbstractURLOpener a_URLOpener) {
        if (a_notifier != null) {
            this.m_notifier = a_notifier;
        }
        if (a_URLOpener != null) {
            this.m_URLOpener = a_URLOpener;
        }
    }

    public final boolean openEMail(String a_mailto) {
        if (a_mailto == null) {
            return false;
        }
        if (!a_mailto.startsWith(URL_MAIL_TO)) {
            return this.openLink(URL_MAIL_TO + a_mailto);
        }
        return this.openLink(a_mailto);
    }

    public final String getDefaultBrowserPath() {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.getBrowserPath();
        }
        return null;
    }

    public final boolean isDefaultURLAvailable() {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.getDefaultURL() != null && this.m_URLOpener.getBrowserCommand() != null;
        }
        return false;
    }

    public final boolean openBrowser() {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.openBrowser();
        }
        return false;
    }

    public final boolean openBrowser(String a_browserCommand) {
        if (this.m_URLOpener != null) {
            return this.m_URLOpener.openBrowser(a_browserCommand);
        }
        LogHolder.log(4, LogType.GUI, "No URL opener available!");
        return false;
    }

    public final boolean openURL(URL a_url) {
        boolean success = false;
        String[] browser = BROWSERLIST;
        String url = this.getAsString(a_url);
        this.m_notifier.checkNotify(a_url);
        if (this.m_URLOpener != null) {
            success = this.m_URLOpener.openURL(a_url);
        }
        if (!success && a_url != null) {
            success = this.openLink(url);
        }
        if (!success && a_url != null) {
            for (int i = 0; i < browser.length; ++i) {
                try {
                    Runtime.getRuntime().exec(new String[]{browser[i], url});
                    success = true;
                    break;
                }
                catch (SecurityException a_e) {
                    LogHolder.log(3, LogType.MISC, a_e);
                    break;
                }
                catch (Exception ex) {
                    continue;
                }
            }
        }
        if (!success) {
            LogHolder.log(3, LogType.MISC, "Cannot open URL " + url + " in browser");
        }
        return success;
    }

    public abstract String getConfigPath(String var1, boolean var2);

    protected abstract boolean openLink(String var1);

    public final String executeRuntime(String a_strCommand) throws IOException {
        final StringBuffer buffer = new StringBuffer();
        final Process p = Runtime.getRuntime().exec(a_strCommand);
        Thread readStdErr = new Thread(new Runnable(){

            public void run() {
                BufferedReader iner = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String output;
                    while ((output = iner.readLine()) != null) {
                        buffer.append(output + "\n");
                    }
                }
                catch (IOException ex) {
                    LogHolder.log(7, LogType.MISC, ex);
                }
            }
        });
        readStdErr.start();
        try {
            readStdErr.join(500L);
        }
        catch (InterruptedException a_e) {
            // empty catch block
        }
        Util.interrupt(readStdErr);
        return buffer.toString();
    }

    public final boolean execute(String a_strCommand) {
        Exception ex = null;
        final StringBuffer buffer = new StringBuffer();
        try {
            final Process p = Runtime.getRuntime().exec(a_strCommand);
            Thread readStdErr = new Thread(new Runnable(){

                public void run() {
                    BufferedReader iner = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    try {
                        String output;
                        while ((output = iner.readLine()) != null) {
                            buffer.append(output + "\n");
                        }
                    }
                    catch (IOException ex) {
                        LogHolder.log(7, LogType.MISC, ex);
                    }
                }
            });
            readStdErr.start();
            try {
                readStdErr.join(500L);
            }
            catch (InterruptedException a_e) {
                // empty catch block
            }
            Util.interrupt(readStdErr);
        }
        catch (Exception a_e) {
            ex = a_e;
        }
        if (ex != null || buffer.length() > 0) {
            LogHolder.log(2, LogType.MISC, "Could not execute system command: '" + a_strCommand + "'\n" + buffer.toString(), ex);
            return false;
        }
        return true;
    }

    protected String getAsString(URL a_url) {
        if (a_url == null) {
            return null;
        }
        return a_url.toString();
    }

    public boolean isHelpAutoInstalled() {
        return false;
    }

    public abstract String getAppdataDefaultDirectory(String var1, boolean var2);

    public String getDefaultHelpPath(String a_applicationName) {
        File classParentFile = ClassUtil.getClassDirectory(this.getClass());
        if (classParentFile != null) {
            return classParentFile.getParent();
        }
        return System.getProperty("user.dir");
    }

    public boolean isMultipleStart(String a_mainClassName, String a_applicationName, String a_applicationFile) {
        Vector activeVMs = AbstractOS.getInstance().getActiveVMs();
        Object vm = null;
        int numJAPInstances = 0;
        for (int i = 0; i < activeVMs.size(); ++i) {
            vm = activeVMs.elementAt(i);
            if (vm == null || vm.toString() == null) continue;
            if (a_mainClassName != null && vm.toString().equals(a_mainClassName) || vm.toString().indexOf(a_applicationName) > 0 || vm.toString().indexOf(a_applicationName + ".jar") > 0 || a_applicationFile != null && vm.toString().indexOf(a_applicationFile) > 0) {
                ++numJAPInstances;
            }
            if (numJAPInstances <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isMultipleStart(Class a_mainClass, String a_applicationName, File a_applicationFile) {
        return this.isMultipleStart(a_mainClass != null ? a_mainClass.getName() : null, a_applicationName, a_applicationFile != null ? a_applicationFile.getName() : null);
    }

    public Vector getActiveVMs() {
        Vector<VMPerfDataFile> r_vms = new Vector<VMPerfDataFile>();
        int id = 0;
        if (!ms_tmpDir.isDirectory()) {
            return r_vms;
        }
        String[] dirs = ms_tmpDir.list(new FilenameFilter(){

            public boolean accept(File a_dir, String a_name) {
                return a_name.startsWith("hsperfdata_");
            }
        });
        if (dirs == null) {
            return r_vms;
        }
        for (int i = 0; i < dirs.length; ++i) {
            String[] files;
            File dir = new File(ms_tmpDir + File.separator + dirs[i]);
            if (!dir.isDirectory() || (files = dir.list()) == null) continue;
            for (int j = 0; j < files.length; ++j) {
                File file = new File(dir + File.separator + files[j]);
                if (!file.isFile() || !file.canRead()) continue;
                try {
                    id = Integer.parseInt(file.getName());
                    if (id == 0) continue;
                    r_vms.addElement(new VMPerfDataFile(id));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return r_vms;
    }

    public static String getInterfaceName(Object a_networkInterface) {
        String strDisplayName;
        try {
            Class<?> classNetworkInterface = Class.forName("java.net.NetworkInterface");
            if (!classNetworkInterface.isInstance(a_networkInterface)) {
                return null;
            }
            Method methGetDisplayName = classNetworkInterface.getMethod("getDisplayName", null);
            strDisplayName = (String)methGetDisplayName.invoke(a_networkInterface, (Object[])null);
        }
        catch (Exception e) {
            LogHolder.log(4, LogType.NET, e);
            return null;
        }
        if (a_networkInterface == null || strDisplayName == null) {
            return null;
        }
        return strDisplayName;
    }

    public boolean isVirtualBoxInterface(Object a_networkInterface) {
        String strDisplayName = AbstractOS.getInterfaceName(a_networkInterface);
        return strDisplayName != null && strDisplayName.indexOf("VirtualBox") >= 0;
    }

    public boolean copyAsRoot(File a_sourceFile, File a_targetDirectory, AbstractRetryCopyProcess a_checkRetry) {
        return false;
    }

    public String getTempPath() {
        return AbstractOS.getDefaultTempPath();
    }

    public static String getDefaultTempPath() {
        String tempDir = null;
        try {
            tempDir = System.getProperty("java.io.tmpdir", null);
            if (tempDir != null && !tempDir.endsWith(File.separator)) {
                tempDir = tempDir + File.separator;
            }
        }
        catch (Throwable a_e) {
            LogHolder.log(3, LogType.MISC, a_e);
        }
        return tempDir;
    }

    public ProxyInterface getProxyInterface(IPasswordReader a_passwordReader) {
        return null;
    }

    public String getProperty(String a_systemProperty) {
        String property = null;
        if (a_systemProperty == null || a_systemProperty.trim().length() == 0) {
            return null;
        }
        try {
            property = System.getProperty(a_systemProperty, null);
        }
        catch (Throwable a_e) {
            LogHolder.log(3, LogType.MISC, "Could not get system property " + a_systemProperty);
        }
        return property;
    }

    public String getenv(String a_environmentVariable) {
        String env = null;
        if (a_environmentVariable == null || a_environmentVariable.trim().length() == 0) {
            return null;
        }
        try {
            env = System.getenv(a_environmentVariable);
        }
        catch (SecurityException a_e) {
            LogHolder.log(3, LogType.MISC, a_e);
        }
        catch (Error a_e) {
            // empty catch block
        }
        if (env == null && this.m_envVars != null) {
            env = this.m_envVars.getProperty(a_environmentVariable);
        }
        if (env == null) {
            try {
                env = System.getProperty(a_environmentVariable);
            }
            catch (Throwable a_e) {
                LogHolder.log(3, LogType.MISC, a_e);
            }
        }
        return env;
    }

    protected void initEnv(String a_envCommand) {
        try {
            this.m_envVars = new Properties();
            InitEnvRunner runner = new InitEnvRunner();
            runner.m_envCommand = a_envCommand;
            Thread threadKillProcces = new Thread(runner);
            threadKillProcces.setDaemon(true);
            threadKillProcces.start();
            LogHolder.log(7, LogType.MISC, "initEnv -  killing the environment process starts sleeping");
            threadKillProcces.join(5000L);
            LogHolder.log(7, LogType.MISC, "initEnv -  killing the environment process ends sleeping");
            if (runner.envProcess != null) {
                runner.envProcess.destroy();
            }
            LogHolder.log(7, LogType.MISC, "initEnv -  killing the environment process -- killed.");
            threadKillProcces.interrupt();
            LogHolder.log(7, LogType.MISC, "initEnv -  killing the environment process ended.");
        }
        catch (Throwable t) {
            LogHolder.log(7, LogType.MISC, "initEnv - excpetion while killing the environment process");
            LogHolder.log(7, LogType.MISC, t);
        }
    }

    public synchronized boolean isJavaWebstart() {
        if (ms_iJavaWebstart < 0) {
            String javaRuntime = System.getProperty("java.runtime.name");
            if (System.getProperty("jnlpx.home") != null) {
                LogHolder.log(6, LogType.MISC, "Detected a Webstart using Sun's JRE.");
                ms_iJavaWebstart = 1;
                return true;
            }
            if (javaRuntime.indexOf("Java(TM)") > -1) {
                LogHolder.log(6, LogType.MISC, "Using Sun's JRE without Webstart.");
                ms_iJavaWebstart = 0;
                return false;
            }
            if (javaRuntime.indexOf("OpenJDK") > -1) {
                File classParentFile = ClassUtil.getClassDirectory(this.getClass());
                if (classParentFile != null) {
                    if (classParentFile.getParent().indexOf(".netx") > -1) {
                        LogHolder.log(6, LogType.MISC, "Detected a Webstart using OpenJDK or IcedTea.");
                        ms_iJavaWebstart = 1;
                        return true;
                    }
                    LogHolder.log(6, LogType.MISC, "Using OpenJDK or IcedTea without Webstart.");
                    ms_iJavaWebstart = 0;
                    return false;
                }
                LogHolder.log(6, LogType.MISC, "We could not test for web start...");
                ms_iJavaWebstart = 0;
                return false;
            }
            LogHolder.log(3, LogType.MISC, "Could not determine Java Runtime name and, therefore, whether Webstart is used or not!");
            ms_iJavaWebstart = 0;
            return false;
        }
        if (ms_iJavaWebstart == 0) {
            return false;
        }
        return ms_iJavaWebstart == 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_iJavaWebstart = -1;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            if (tmpDir.compareTo("/var/tmp/") == 0) {
                tmpDir = "/tmp/";
            }
            if (tmpDir.lastIndexOf(File.pathSeparator) != tmpDir.length() - 1) {
                tmpDir = tmpDir + File.separator;
            }
        } else {
            tmpDir = "." + File.separator;
        }
        ms_tmpDir = new File(tmpDir);
    }

    private class InitEnvRunner
    implements Runnable {
        public Process envProcess;
        public BufferedReader br;
        public InputStream inProcess;
        public String m_envCommand;

        private InitEnvRunner() {
        }

        public void run() {
            try {
                this.envProcess = Runtime.getRuntime().exec(this.m_envCommand);
                this.inProcess = this.envProcess.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.inProcess));
                String line = null;
                while ((line = this.br.readLine()) != null) {
                    LogHolder.log(7, LogType.MISC, "initEnv - read evironment line: " + line);
                    int idx = line.indexOf(61);
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    ((Hashtable)AbstractOS.this.m_envVars).put(key, value);
                }
                LogHolder.log(7, LogType.MISC, "initEnv - read evironment lines finished.");
            }
            catch (IOException a_e) {
                LogHolder.log(2, LogType.MISC, "Could not parse environment variables.", a_e);
            }
            catch (SecurityException a_e) {
                LogHolder.log(3, LogType.MISC, "Could not parse environment variables.", a_e);
            }
            catch (Throwable t) {
                LogHolder.log(7, LogType.MISC, "initEnv - excpetion");
                LogHolder.log(7, LogType.MISC, t);
            }
        }
    }

    public static abstract class AbstractRetryCopyProcess {
        private int m_maxSteps;
        private int m_currentStep;

        public AbstractRetryCopyProcess(int a_maxSteps) {
            if (a_maxSteps <= 0) {
                throw new IllegalArgumentException("Max steps <=0! Value: " + a_maxSteps);
            }
            this.m_maxSteps = a_maxSteps;
            this.m_currentStep = 0;
        }

        public abstract boolean checkRetry();

        public final int getMaxProgressSteps() {
            return this.m_maxSteps;
        }

        public final long getProgressLoopWaitMilliseconds() {
            return 500L;
        }

        public final int getCurrentStep() {
            return this.m_currentStep;
        }

        public void reset() {
            this.m_currentStep = 0;
        }

        public boolean incrementProgress() {
            if (this.m_currentStep < this.m_maxSteps) {
                ++this.m_currentStep;
                return true;
            }
            return false;
        }
    }

    public static interface IURLErrorNotifier {
        public void checkNotify(URL var1);
    }

    public static abstract class AbstractURLOpener {
        private Process m_portableFirefoxProcess = null;
        private boolean m_bOneSessionOnly = false;

        public final synchronized boolean openURL(URL a_url) {
            return this.openURL(a_url, this.getBrowserCommand());
        }

        public synchronized boolean openURL(URL a_url, String a_browserCommand) {
            if (a_browserCommand == null) {
                LogHolder.log(3, LogType.GUI, "No path to portable browser was found. Maybe we should use the default browser instead. Browser command: " + a_browserCommand + " Default URL: " + a_url);
                return false;
            }
            if (this.m_portableFirefoxProcess != null && this.m_bOneSessionOnly) {
                try {
                    int ffExitValue = this.m_portableFirefoxProcess.exitValue();
                    LogHolder.log(6, LogType.MISC, "previous portable firefox process exited " + (ffExitValue == 0 ? "normally " : "anormally ") + "(exit value " + ffExitValue + ").");
                }
                catch (IllegalThreadStateException itse) {
                    LogHolder.log(4, LogType.MISC, "Portable Firefox process is still running!");
                    return true;
                }
            }
            String[] cmd = a_url == null ? new String[]{a_browserCommand} : new String[]{a_browserCommand, a_url.toString()};
            try {
                this.m_portableFirefoxProcess = Runtime.getRuntime().exec(cmd);
                return true;
            }
            catch (SecurityException se) {
                LogHolder.log(4, LogType.MISC, "You are not allowed to launch portable firefox: ", se);
            }
            catch (IOException ioe3) {
                LogHolder.log(4, LogType.MISC, "Error occured while launching portable browser with command '" + cmd[0] + (cmd.length > 1 ? " " + cmd[1] : "") + "'", ioe3);
            }
            return false;
        }

        public abstract String getBrowserCommand();

        public abstract String getBrowserPath();

        public abstract URL getDefaultURL();

        public final synchronized boolean openBrowser() {
            return this.openBrowser(this.getBrowserCommand());
        }

        public final synchronized boolean openBrowser(String a_browserCommand) {
            this.m_bOneSessionOnly = true;
            boolean bReturn = this.openURL(this.getDefaultURL(), a_browserCommand);
            this.m_bOneSessionOnly = false;
            return bReturn;
        }
    }
}

