/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPaymentSettings
implements IXMLEncodable {
    private Hashtable m_paymentSettings = new Hashtable();
    private Document m_docTheSettings = null;

    public XMLPaymentSettings(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
    }

    public XMLPaymentSettings() {
    }

    public XMLPaymentSettings(Hashtable allSettings) {
        this.m_paymentSettings = allSettings;
        this.m_docTheSettings = XMLUtil.createDocument();
        this.internal_toXmlElement(this.m_docTheSettings);
    }

    public XMLPaymentSettings(Element xml) throws Exception {
        this.setValues(xml);
    }

    public XMLPaymentSettings(Document document) throws Exception {
        this.setValues(document.getDocumentElement());
    }

    public void addSetting(String name, String value) {
        this.m_paymentSettings.put(name, value);
    }

    public String getSettingValue(String name) {
        return (String)this.m_paymentSettings.get(name);
    }

    public Calendar getEndDate() {
        Calendar now = Calendar.getInstance();
        String unit = this.getSettingValue("FlatrateDurationUnit");
        if (unit.equalsIgnoreCase("day") || unit.equalsIgnoreCase("days")) {
            int day = now.get(6);
            int duration = Integer.parseInt(this.getSettingValue("FlatrateDuration"));
            now.set(6, (day + duration) % now.getMaximum(6));
        } else if (unit.equalsIgnoreCase("week") || unit.equalsIgnoreCase("weeks")) {
            int week = now.get(3);
            int duration = Integer.parseInt(this.getSettingValue("FlatrateDuration"));
            now.set(3, (week + duration) % now.getMaximum(3));
        } else if (unit.equalsIgnoreCase("month") || unit.equalsIgnoreCase("months")) {
            int month = now.get(2);
            int duration = Integer.parseInt(this.getSettingValue("FlatrateDuration"));
            now.set(2, (month + duration) % now.getMaximum(2));
        } else if (unit.equalsIgnoreCase("year") || unit.equalsIgnoreCase("years")) {
            int year = now.get(1);
            int duration = Integer.parseInt(this.getSettingValue("FlatrateDuration"));
            now.set(1, year + duration);
        }
        return now;
    }

    public Enumeration getSettingNames() {
        return this.m_paymentSettings.keys();
    }

    private Element internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("PaymentSettings");
        elemRoot.setAttribute("version", "1.0");
        a_doc.appendChild(elemRoot);
        Enumeration settingNames = this.m_paymentSettings.keys();
        while (settingNames.hasMoreElements()) {
            String name = (String)settingNames.nextElement();
            String value = (String)this.m_paymentSettings.get(name);
            Element elem = a_doc.createElement("Setting");
            XMLUtil.setAttribute(elem, "name", name);
            XMLUtil.setValue((Node)elem, value);
            elemRoot.appendChild(elem);
        }
        return elemRoot;
    }

    private void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals("PaymentSettings") || !elemRoot.getAttribute("version").equals("1.0")) {
            throw new Exception("wrong XML format");
        }
        NodeList settingElements = elemRoot.getElementsByTagName("Setting");
        for (int i = 0; i < settingElements.getLength(); ++i) {
            Element curElem = (Element)settingElements.item(i);
            String value = XMLUtil.parseValue((Node)curElem, (String)null);
            String name = XMLUtil.parseAttribute((Node)curElem, "name", null);
            this.m_paymentSettings.put(name, value);
        }
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheSettings.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }
}

