/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.client;

import anon.client.TrustModel;
import anon.forward.client.ClientForwardException;
import anon.forward.client.ForwardConnectionDescriptor;
import anon.forward.client.ProgressCounter;
import anon.infoservice.MixCascade;
import anon.transport.connection.IStreamConnection;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultClientProtocolHandler {
    private static final int PROTOCOL_VERSION = 2;
    private static final int MAXIMUM_PROTOCOLMESSAGE_SIZE = 1000000;
    private static final int STATE_INITIALIZE = 0;
    private static final int STATE_OFFER_RECEIVED = 1;
    private static final int STATE_CASCADE_SELECTED = 2;
    private static final int STATE_FORWARDING = 3;
    private static final int STATE_CLOSED_AFTER_ERROR = 4;
    private static final byte[] MESSAGE_START_SIGNATURE = new byte[]{-1, 0, -16, 15};
    private static final byte[] MESSAGE_START_COMPRESS_SIGNATURE = new byte[]{-1, 15, -16, 15};
    private static final byte[] MESSAGE_END_SIGNATURE = new byte[]{-1, 0, -31, 30};
    private IStreamConnection m_connection;
    private int m_state;
    private int m_minDummyTrafficInterval;
    private MixCascade m_selectedMixCascade;
    private ProgressCounter m_progressCounter;

    public DefaultClientProtocolHandler(IStreamConnection a_connection) {
        this.m_connection = a_connection;
        this.m_state = 0;
        this.m_progressCounter = new ProgressCounter();
    }

    public ForwardConnectionDescriptor getConnectionDescriptor() throws ClientForwardException {
        ForwardConnectionDescriptor connectionDescriptor;
        block30: {
            connectionDescriptor = new ForwardConnectionDescriptor();
            if (this.m_state == 0) {
                byte[] protocolPacket = null;
                try {
                    protocolPacket = this.xmlToProtocolPacket(this.generateConnectionRequest());
                }
                catch (Exception e) {
                    throw new ClientForwardException(255, "XML transforming error (" + e.toString() + ").");
                }
                this.sendProtocolMessage(protocolPacket);
                byte[] message = this.readProtocolMessage();
                Document doc = null;
                try {
                    doc = XMLUtil.toXMLDocument(message);
                }
                catch (Exception e) {
                    throw new ClientForwardException(255, "Error while parsing XML message (" + e.toString() + ").");
                }
                NodeList japRoutingNodes = doc.getElementsByTagName("JAPRouting");
                if (japRoutingNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (JAPRouting node).");
                }
                Element japRoutingNode = (Element)japRoutingNodes.item(0);
                NodeList protocolNodes = japRoutingNode.getElementsByTagName("Protocol");
                if (protocolNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (Protocol node).");
                }
                Element protocolNode = (Element)protocolNodes.item(0);
                int protocolVersion = -1;
                try {
                    protocolVersion = Integer.parseInt(protocolNode.getAttribute("version"));
                }
                catch (Exception e) {
                    throw new ClientForwardException(255, "Error in XML structure (Protocol node -> version info).");
                }
                if (protocolVersion != 2) {
                    throw new ClientForwardException(3, "Forwarder is using protocol version " + Integer.toString(protocolVersion) + ", but we use version " + Integer.toString(2) + ".");
                }
                NodeList requestNodes = japRoutingNode.getElementsByTagName("Request");
                if (requestNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (Request node).");
                }
                Element requestNode = (Element)requestNodes.item(0);
                String subject = requestNode.getAttribute("subject");
                if (!subject.equals("connection")) {
                    throw new ClientForwardException(255, "Error in XML structure (Request node -> subject).");
                }
                String msg = requestNode.getAttribute("msg");
                if (!msg.equals("offer")) {
                    throw new ClientForwardException(255, "Error in XML structure (Request node -> msg).");
                }
                NodeList allowedCascadesNodes = requestNode.getElementsByTagName("AllowedCascades");
                if (allowedCascadesNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (AllowedCascades node).");
                }
                Element allowedCascadesNode = (Element)allowedCascadesNodes.item(0);
                NodeList mixCascadeNodes = allowedCascadesNode.getElementsByTagName("MixCascade");
                for (int i = 0; i < mixCascadeNodes.getLength(); ++i) {
                    Element currentMixCascadeNode = (Element)mixCascadeNodes.item(i);
                    try {
                        MixCascade cascade = new MixCascade(currentMixCascadeNode);
                        if (!TrustModel.getCurrentTrustModel().isTrusted(cascade)) continue;
                        connectionDescriptor.addMixCascade(cascade);
                        continue;
                    }
                    catch (XMLParseException e) {
                        LogHolder.log(3, LogType.MISC, "Error while parsing MixCascade", e);
                    }
                }
                NodeList qualityOfServiceNodes = requestNode.getElementsByTagName("QualityOfService");
                if (qualityOfServiceNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (QualityOfService node).");
                }
                Element qualityOfServiceNode = (Element)qualityOfServiceNodes.item(0);
                NodeList maximumBandwidthNodes = qualityOfServiceNode.getElementsByTagName("MaximumBandwidth");
                if (maximumBandwidthNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (MaximumBandwidth node).");
                }
                Element maximumBandwidthNode = (Element)maximumBandwidthNodes.item(0);
                int maximumBandwidth = -1;
                try {
                    maximumBandwidth = Integer.parseInt(maximumBandwidthNode.getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (maximumBandwidth < 0) {
                    throw new ClientForwardException(255, "Error in XML structure (MaximumBandwidth has illegal value).");
                }
                connectionDescriptor.setMaximumBandwidth(maximumBandwidth);
                NodeList guaranteedBandwidthNodes = qualityOfServiceNode.getElementsByTagName("GuaranteedBandwidth");
                if (guaranteedBandwidthNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (GuaranteedBandwidth node).");
                }
                Element guaranteedBandwidthNode = (Element)guaranteedBandwidthNodes.item(0);
                int guaranteedBandwidth = -1;
                try {
                    guaranteedBandwidth = Integer.parseInt(guaranteedBandwidthNode.getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (guaranteedBandwidth < 0) {
                    throw new ClientForwardException(255, "Error in XML structure (GuaranteedBandwidth has illegal value).");
                }
                connectionDescriptor.setGuaranteedBandwidth(guaranteedBandwidth);
                NodeList dummyTrafficNodes = japRoutingNode.getElementsByTagName("DummyTraffic");
                if (dummyTrafficNodes.getLength() == 0) {
                    throw new ClientForwardException(255, "Error in XML structure (DummyTraffic node).");
                }
                Element dummyTrafficNode = (Element)dummyTrafficNodes.item(0);
                try {
                    this.m_minDummyTrafficInterval = Integer.parseInt(dummyTrafficNode.getAttribute("interval"));
                    if (this.m_minDummyTrafficInterval < -1) {
                        throw new Exception("Illegal value.");
                    }
                    break block30;
                }
                catch (Exception e) {
                    throw new ClientForwardException(255, "Error in XML structure (DummyTraffic node -> interval info).");
                }
            }
            throw new ClientForwardException(2, "Wrong protocol state to call this method (current state: " + Integer.toString(this.m_state) + ").");
        }
        connectionDescriptor.setMinDummyTrafficInterval(this.m_minDummyTrafficInterval);
        this.m_state = 1;
        return connectionDescriptor;
    }

    public MixCascade getSelectedService() {
        return this.m_selectedMixCascade;
    }

    public void selectMixCascade(MixCascade a_mixCascade) throws ClientForwardException {
        byte[] protocolPacket;
        if (this.m_state == 1) {
            Document doc = null;
            try {
                doc = XMLUtil.createDocument();
            }
            catch (Exception e) {
                throw new ClientForwardException(255, "XML DocumentBuilder error (" + e.toString() + ").");
            }
            Element japRoutingNode = doc.createElement("JAPRouting");
            Element requestNode = doc.createElement("Request");
            requestNode.setAttribute("subject", "cascade");
            requestNode.setAttribute("msg", "select");
            Element mixCascadeNode = doc.createElement("MixCascade");
            mixCascadeNode.setAttribute("id", a_mixCascade.getId());
            requestNode.appendChild(mixCascadeNode);
            japRoutingNode.appendChild(requestNode);
            doc.appendChild(japRoutingNode);
            protocolPacket = null;
            try {
                protocolPacket = this.xmlToProtocolPacket(doc);
            }
            catch (Exception e) {
                throw new ClientForwardException(255, "XML transforming error (" + e.toString() + ").");
            }
        }
        throw new ClientForwardException(2, "Wrong protocol state to call this method (current state: " + Integer.toString(this.m_state) + ").");
        this.sendProtocolMessage(protocolPacket);
        this.m_selectedMixCascade = a_mixCascade;
        this.m_state = 2;
    }

    private Document generateConnectionRequest() throws ClientForwardException {
        Document doc = null;
        try {
            doc = XMLUtil.createDocument();
        }
        catch (Exception e) {
            throw new ClientForwardException(255, "XML DocumentBuilder error (" + e.toString() + ").");
        }
        Element japRoutingNode = doc.createElement("JAPRouting");
        Element protocolNode = doc.createElement("Protocol");
        protocolNode.setAttribute("version", Integer.toString(2));
        japRoutingNode.appendChild(protocolNode);
        Element requestNode = doc.createElement("Request");
        requestNode.setAttribute("subject", "connection");
        requestNode.setAttribute("msg", "request");
        requestNode.setAttribute("compress", "zip");
        japRoutingNode.appendChild(requestNode);
        doc.appendChild(japRoutingNode);
        return doc;
    }

    private byte[] readProtocolMessage() throws ClientForwardException {
        byte[] messageHeader = new byte[MESSAGE_START_SIGNATURE.length + 4];
        byte[] currentMessage = null;
        byte[] brutMessage = null;
        boolean isCompress = false;
        try {
            int readBytes = 0;
            while (readBytes < messageHeader.length) {
                int lastRead = this.m_connection.getInputStream().read(messageHeader, readBytes, messageHeader.length - readBytes);
                if (lastRead == -1) {
                    throw new IOException("Read error: connection was closed.");
                }
                readBytes = lastRead + readBytes;
            }
            byte[] messageStart = new byte[MESSAGE_START_SIGNATURE.length];
            System.arraycopy(messageHeader, 0, messageStart, 0, MESSAGE_START_SIGNATURE.length);
            if (!this.checkSignature(messageStart, MESSAGE_START_SIGNATURE)) {
                if (this.checkSignature(messageStart, MESSAGE_START_COMPRESS_SIGNATURE)) {
                    isCompress = true;
                } else {
                    throw new ClientForwardException(2, "Protocol error (invalid start signature).");
                }
            }
            byte[] netLength = new byte[4];
            System.arraycopy(messageHeader, MESSAGE_START_SIGNATURE.length, netLength, 0, 4);
            int incomingMessageLength = 0;
            try {
                incomingMessageLength = new DataInputStream(new ByteArrayInputStream(netLength)).readInt();
            }
            catch (Exception e) {
                throw new IOException("Error while reading message length.");
            }
            if (incomingMessageLength < 0) {
                throw new ClientForwardException(2, "Protocol error (invalid length).");
            }
            byte[] remainingMessage = new byte[incomingMessageLength + MESSAGE_END_SIGNATURE.length];
            readBytes = 0;
            this.m_progressCounter.setMax(incomingMessageLength);
            int byteReadStep = 1000;
            while (readBytes < remainingMessage.length) {
                int lastRead = this.m_connection.getInputStream().read(remainingMessage, readBytes, Math.min(remainingMessage.length - readBytes, byteReadStep));
                if (lastRead == -1) {
                    throw new IOException("Read error: connection was closed.");
                }
                readBytes = lastRead + readBytes;
                this.m_progressCounter.incrValue(lastRead);
            }
            byte[] messageEnd = new byte[MESSAGE_END_SIGNATURE.length];
            System.arraycopy(remainingMessage, incomingMessageLength, messageEnd, 0, MESSAGE_END_SIGNATURE.length);
            if (!this.checkSignature(messageEnd, MESSAGE_END_SIGNATURE)) {
                throw new ClientForwardException(2, "Protocol error (invalid end signature).");
            }
            brutMessage = new byte[incomingMessageLength];
            System.arraycopy(remainingMessage, 0, brutMessage, 0, incomingMessageLength);
            currentMessage = isCompress ? ZLibTools.decompress(brutMessage) : brutMessage;
        }
        catch (IOException e) {
            throw new ClientForwardException(1, "Connection error (" + e.toString() + ").");
        }
        this.m_progressCounter.close();
        return currentMessage;
    }

    private void sendProtocolMessage(byte[] a_message) throws ClientForwardException {
        try {
            this.m_connection.getOutputStream().write(a_message);
            this.m_connection.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new ClientForwardException(1, "Connection error (" + e.toString() + ").");
        }
    }

    private boolean checkSignature(byte[] a_signature1, byte[] a_signature2) {
        boolean identical = false;
        try {
            if (a_signature1.length == a_signature2.length) {
                identical = true;
                for (int i = 0; i < a_signature1.length && identical; ++i) {
                    if (a_signature1[i] == a_signature2[i]) continue;
                    identical = false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return identical;
    }

    private byte[] xmlToProtocolPacket(Document a_doc) throws Exception {
        return this.createProtocolPacket(XMLUtil.toByteArray(a_doc));
    }

    private byte[] createProtocolPacket(byte[] a_data) {
        byte[] protocolPacket = new byte[MESSAGE_START_SIGNATURE.length + 4 + a_data.length + MESSAGE_END_SIGNATURE.length];
        System.arraycopy(MESSAGE_START_SIGNATURE, 0, protocolPacket, 0, MESSAGE_START_SIGNATURE.length);
        ByteArrayOutputStream dataLength = new ByteArrayOutputStream(4);
        try {
            new DataOutputStream(dataLength).writeInt(a_data.length);
            System.arraycopy(dataLength.toByteArray(), 0, protocolPacket, MESSAGE_START_SIGNATURE.length, 4);
        }
        catch (Exception e) {
            byte[] dummyLength = new byte[]{-1, -1, -1, -1};
            System.arraycopy(dummyLength, 0, protocolPacket, MESSAGE_START_SIGNATURE.length, 4);
        }
        System.arraycopy(a_data, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4, a_data.length);
        System.arraycopy(MESSAGE_END_SIGNATURE, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4 + a_data.length, MESSAGE_END_SIGNATURE.length);
        return protocolPacket;
    }

    public ProgressCounter getPacketCounter() {
        return this.m_progressCounter;
    }
}

