/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.VMSFTPEntryParser;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class VMSVersioningFTPEntryParser
extends VMSFTPEntryParser {
    private Perl5Matcher _preparse_matcher_;
    private Pattern _preparse_pattern_;
    private static final String PRE_PARSE_REGEX = "(.*);([0-9]+)\\s*.*";

    public VMSVersioningFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSVersioningFTPEntryParser(FTPClientConfig config) {
        this.configure(config);
        try {
            this._preparse_matcher_ = new Perl5Matcher();
            this._preparse_pattern_ = new Perl5Compiler().compile(PRE_PARSE_REGEX);
        }
        catch (MalformedPatternException e) {
            throw new IllegalArgumentException("Unparseable regex supplied:  (.*);([0-9]+)\\s*.*");
        }
    }

    public Vector preParse(Vector original) {
        NameVersion existing;
        NameVersion nv;
        String version;
        String name;
        MatchResult result;
        String entry;
        original = super.preParse(original);
        Hashtable<String, NameVersion> existingEntries = new Hashtable<String, NameVersion>();
        int i = 0;
        while (i < original.size()) {
            entry = ((String)original.elementAt(i)).trim();
            result = null;
            if (this._preparse_matcher_.matches(entry, this._preparse_pattern_)) {
                result = this._preparse_matcher_.getMatch();
                name = result.group(1);
                version = result.group(2);
                nv = new NameVersion(name, version);
                existing = (NameVersion)existingEntries.get(name);
                if (null != existing && nv.versionNumber < existing.versionNumber) {
                    original.removeElementAt(i);
                    continue;
                }
                existingEntries.put(name, nv);
            }
            ++i;
        }
        for (i = original.size() - 1; i >= 0; --i) {
            entry = ((String)original.elementAt(i)).trim();
            result = null;
            if (!this._preparse_matcher_.matches(entry, this._preparse_pattern_)) continue;
            result = this._preparse_matcher_.getMatch();
            name = result.group(1);
            version = result.group(2);
            nv = new NameVersion(name, version);
            existing = (NameVersion)existingEntries.get(name);
            if (null == existing || nv.versionNumber >= existing.versionNumber) continue;
            original.removeElementAt(i);
        }
        return original;
    }

    protected boolean isVersioning() {
        return true;
    }

    private class NameVersion {
        String name;
        int versionNumber;

        NameVersion(String name, String vers) {
            this.name = name;
            this.versionNumber = Integer.parseInt(vers);
        }
    }
}

