/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class CoinstackProgressBarUI
extends BasicProgressBarUI {
    private static final int Y_OFFSET = 6;
    private static final int X_OFFSET = 6;
    private static final int[] X_SHIFT = new int[]{0, 3, 1, -2, -1, 0, -1, 0};
    private Image m_imgCoinImage;
    private int m_yFactor;
    private int m_xPos;
    private int m_yPos;
    private int m_imageHeight;
    private int m_imageWidth;
    private int m_height;
    private int m_width;

    public CoinstackProgressBarUI(ImageIcon imageIcon, int min, int max) {
        this.m_imgCoinImage = imageIcon.getImage();
        this.m_imageHeight = this.m_imgCoinImage.getHeight(null);
        this.m_imageWidth = this.m_imgCoinImage.getWidth(null);
        this.m_yFactor = this.m_imageHeight / 3;
        this.m_width = 12 + this.m_imageWidth + 4 + 3;
        this.m_height = 12 + this.m_imageHeight + this.m_yFactor * (max - min - 1);
    }

    public void paint(Graphics g, JComponent c) {
        JProgressBar pb = (JProgressBar)c;
        this.m_height = 12 + this.m_imageHeight + this.m_yFactor * (pb.getMaximum() - pb.getMinimum() - 1);
        g.setColor(Color.gray);
        this.m_xPos = 6;
        this.m_yPos = this.m_height - 6;
        int y_pos_end = this.m_yPos - (this.m_imageHeight + this.m_yFactor * (pb.getMaximum() - pb.getMinimum() - 1));
        g.drawLine(this.m_xPos, this.m_yPos, this.m_xPos, y_pos_end);
        int y_rule_middle = this.m_yPos - (this.m_yPos - y_pos_end) / 2;
        g.drawLine(this.m_xPos, this.m_yPos, this.m_xPos + 3, this.m_yPos);
        g.drawLine(this.m_xPos, y_pos_end, this.m_xPos + 3, y_pos_end);
        g.drawLine(this.m_xPos, y_rule_middle, this.m_xPos + 3, y_rule_middle);
        if (pb.getValue() == pb.getMinimum()) {
            return;
        }
        int x_pos = 10;
        int y_pos = this.m_height - 6 - this.m_imageHeight + 1;
        for (int i = 0; i < pb.getValue() - pb.getMinimum(); ++i) {
            g.drawImage(this.m_imgCoinImage, x_pos += X_SHIFT[i % X_SHIFT.length], y_pos, null);
            y_pos -= this.m_yFactor;
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(this.m_width, this.m_height);
    }
}

