/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.util.JAPMessages;
import anon.util.XMLUtil;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAPRoutingConnectionClass {
    private int m_connectionClassIdentifier;
    private String m_connectionClassName;
    private int m_maximumBandwidth;
    private int m_relativeBandwidth;

    public JAPRoutingConnectionClass(int a_connectionClassIdentifier, String a_connectionClassName, int a_maximumBandwidth, int a_relativeBandwidth) {
        this.m_connectionClassIdentifier = a_connectionClassIdentifier;
        this.m_connectionClassName = a_connectionClassName;
        this.m_maximumBandwidth = a_maximumBandwidth;
        this.setRelativeBandwidth(a_relativeBandwidth);
    }

    public int getIdentifier() {
        return this.m_connectionClassIdentifier;
    }

    public int getMaximumBandwidth() {
        return this.m_maximumBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumBandwidth(int a_maximumBandwidth) {
        if (this.m_connectionClassIdentifier == 8) {
            JAPRoutingConnectionClass jAPRoutingConnectionClass = this;
            synchronized (jAPRoutingConnectionClass) {
                this.m_maximumBandwidth = a_maximumBandwidth;
                this.setRelativeBandwidth(this.getRelativeBandwidth());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentBandwidth() {
        int currentAbsoluteBandwidth = 0;
        JAPRoutingConnectionClass jAPRoutingConnectionClass = this;
        synchronized (jAPRoutingConnectionClass) {
            currentAbsoluteBandwidth = this.m_maximumBandwidth * this.m_relativeBandwidth / 100;
        }
        return currentAbsoluteBandwidth;
    }

    public int getMaxSimultaneousConnections() {
        return this.getCurrentBandwidth() / 4000;
    }

    public int getRelativeBandwidth() {
        return this.m_relativeBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelativeBandwidth(int a_relativeBandwidth) {
        JAPRoutingConnectionClass jAPRoutingConnectionClass = this;
        synchronized (jAPRoutingConnectionClass) {
            this.m_relativeBandwidth = a_relativeBandwidth > this.getMinimumRelativeBandwidth() ? a_relativeBandwidth : this.getMinimumRelativeBandwidth();
        }
    }

    public int getMinimumRelativeBandwidth() {
        int maximumBandwidth = this.m_maximumBandwidth;
        return (400000 + (maximumBandwidth - 1)) / maximumBandwidth;
    }

    public String toString() {
        return JAPMessages.getString(this.m_connectionClassName);
    }

    public synchronized Element getSettingsAsXml(Document a_doc) {
        Element connectionClassNode = a_doc.createElement("ConnectionClass");
        Element classIdentifierNode = a_doc.createElement("ClassIdentifier");
        Element maximumBandwidthNode = a_doc.createElement("MaximumBandwidth");
        Element relativeBandwidthNode = a_doc.createElement("RelativeBandwidth");
        XMLUtil.setValue((Node)classIdentifierNode, this.getIdentifier());
        XMLUtil.setValue((Node)maximumBandwidthNode, this.getMaximumBandwidth());
        XMLUtil.setValue((Node)relativeBandwidthNode, this.getRelativeBandwidth());
        connectionClassNode.appendChild(classIdentifierNode);
        connectionClassNode.appendChild(maximumBandwidthNode);
        connectionClassNode.appendChild(relativeBandwidthNode);
        return connectionClassNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadSettingsFromXml(Element a_connectionClassNode) {
        boolean noError = true;
        JAPRoutingConnectionClass jAPRoutingConnectionClass = this;
        synchronized (jAPRoutingConnectionClass) {
            try {
                if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_connectionClassNode, "ClassIdentifier"), this.m_connectionClassIdentifier + 1) != this.m_connectionClassIdentifier) {
                    throw new Exception("JAPRoutingConnectionClass: loadSettingsFromXml: The class identifer doesn't match to this class (class: " + Integer.toString(this.m_connectionClassIdentifier) + ").");
                }
                if (this.m_connectionClassIdentifier == 8) {
                    int maximumBandwidth = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_connectionClassNode, "MaximumBandwidth"), -1);
                    if (maximumBandwidth < 4000) throw new Exception("JAPRoutingConnectionClass: loadSettingsFromXml: Invalid maximum bandwidth value (class: " + Integer.toString(this.m_connectionClassIdentifier) + ").");
                    this.m_maximumBandwidth = maximumBandwidth;
                    this.setRelativeBandwidth(50);
                } else if (XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_connectionClassNode, "MaximumBandwidth"), this.m_maximumBandwidth + 1) != this.m_maximumBandwidth) {
                    throw new Exception("JAPRoutingConnectionClass: loadSettingsFromXml: The maximum bandwidth doesn't match to this class (class: " + Integer.toString(this.m_connectionClassIdentifier) + ").");
                }
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.NET, "JAPRoutingConnectionClass: loadSettingsFromXml: Loading the settings for this connection class failed: " + e.toString());
                noError = false;
            }
            noError = true;
            if (!true) return noError;
            Element relativeBandwidthNode = (Element)XMLUtil.getFirstChildByName(a_connectionClassNode, "RelativeBandwidth");
            if (relativeBandwidthNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClass: loadSettingsFromXml: Error in XML structure (RelativeBandwidth node for class " + Integer.toString(this.m_connectionClassIdentifier) + "): Using default value.");
                return false;
            }
            int relativeBandwidth = XMLUtil.parseValue((Node)relativeBandwidthNode, -1);
            if (relativeBandwidth < this.getMinimumRelativeBandwidth()) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClass: loadSettingsFromXml: Invalid relative bandwidth value for class " + Integer.toString(this.m_connectionClassIdentifier) + ": Using default value.");
                return false;
            }
            this.setRelativeBandwidth(relativeBandwidth);
            return noError;
        }
    }
}

