/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.util.JAPMessages;
import anon.util.Util;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import jap.JAPModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import logging.FileLog;
import logging.ILog;
import logging.LogLevel;
import logging.LogType;

public final class JAPDebug
extends Observable
implements ActionListener,
ILog {
    public static boolean ms_bSystemErrorAllowed = true;
    private int m_debugType = LogType.ALL;
    private int m_debugLevel = 7;
    private static JTextArea m_textareaConsole;
    private static JAPDialog m_frameConsole;
    private static boolean m_bConsole;
    private static volatile boolean ms_bFile;
    private static String ms_strFileName;
    private static FileLog ms_FileLog;
    private static JAPDebug debug;
    private static SimpleDateFormat dateFormatter;
    private WindowAdapter m_winAdapter;
    static /* synthetic */ Class class$java$lang$Runtime;

    private JAPDebug() {
        m_bConsole = false;
        ms_bFile = false;
        ms_strFileName = null;
        this.m_winAdapter = new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent e) {
                JAPDebug jAPDebug = JAPDebug.this;
                synchronized (jAPDebug) {
                    m_bConsole = false;
                    JAPDebug.this.setChanged();
                    JAPDebug.this.notifyObservers();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosed(WindowEvent e) {
                JAPDebug jAPDebug = JAPDebug.this;
                synchronized (jAPDebug) {
                    m_bConsole = false;
                    JAPDebug.this.setChanged();
                    JAPDebug.this.notifyObservers();
                }
            }
        };
    }

    public void finalize() {
        ms_bFile = false;
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static JAPDebug getInstance() {
        if (debug == null) {
            debug = new JAPDebug();
        }
        return debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, int type, String txt) {
        block9: {
            try {
                if (level > this.m_debugLevel || (this.m_debugType & type) == 0) break block9;
                JAPDebug jAPDebug = this;
                synchronized (jAPDebug) {
                    String str = "[" + dateFormatter.format(new Date()) + LogLevel.getLevelName(level) + "] " + txt + "\n";
                    if (!m_bConsole) {
                        if (ms_bSystemErrorAllowed) {
                            System.err.print(str);
                        }
                    } else {
                        m_textareaConsole.append(str);
                        m_textareaConsole.setCaretPosition(m_textareaConsole.getText().length());
                    }
                    if (ms_bFile) {
                        ms_FileLog.log(level, type, txt);
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void setLogType(int type) {
        this.m_debugType = type;
        if (ms_bFile) {
            ms_FileLog.setLogType(type);
        }
    }

    public int getLogType() {
        return this.m_debugType;
    }

    public void setLogLevel(int level) {
        if (level < 0 || level > 7) {
            return;
        }
        this.m_debugLevel = level;
        if (ms_bFile) {
            ms_FileLog.setLogLevel(level);
        }
    }

    public int getLogLevel() {
        if (debug == null) {
            JAPDebug.getInstance();
        }
        return JAPDebug.debug.m_debugLevel;
    }

    public static void showConsole(boolean b, Component parent) {
        debug.internal_showConsole(b, parent);
    }

    public static void setLogToFile(String strFilename) throws IOException {
        if (strFilename == null || strFilename.trim().equals("")) {
            ms_bFile = false;
            ms_FileLog = null;
        } else {
            ms_FileLog = new FileLog(strFilename, 10000000, 2);
            ms_FileLog.setLogLevel(JAPDebug.getInstance().m_debugLevel);
            ms_FileLog.setLogType(JAPDebug.getInstance().m_debugType);
            ms_bFile = true;
        }
        ms_strFileName = strFilename;
    }

    public static boolean isShowConsole() {
        return m_bConsole;
    }

    public static boolean isLogToFile() {
        return ms_bFile;
    }

    public static String getLogFilename() {
        return ms_strFileName;
    }

    public void internal_showConsole(boolean b, Component parent) {
        if (!b && m_bConsole) {
            m_frameConsole.dispose();
            m_frameConsole.removeWindowListener(this.m_winAdapter);
            m_textareaConsole = null;
            m_frameConsole = null;
            m_bConsole = false;
        } else if (b && !m_bConsole) {
            m_frameConsole = new JAPDialog(parent, "Debug-Console", false);
            m_textareaConsole = new JTextArea(null, 20, 30);
            m_textareaConsole.setEditable(false);
            Font f = Font.decode("Courier");
            if (f != null) {
                m_textareaConsole.setFont(f);
            }
            JPanel panel = new JPanel();
            JButton bttnSave = new JButton(JAPMessages.getString("bttnSaveAs") + "...", GUIUtils.loadImageIcon("saveicon.gif", true));
            bttnSave.setActionCommand("saveas");
            bttnSave.addActionListener(debug);
            JButton bttnCopy = new JButton(JAPMessages.getString("bttnCopy"), GUIUtils.loadImageIcon("copyicon.gif", true));
            bttnCopy.setActionCommand("copy");
            bttnCopy.addActionListener(debug);
            JButton bttnInsertConfig = new JButton(JAPMessages.getString("bttnInsertConfig"), GUIUtils.loadImageIcon("copyintoicon.gif", true));
            bttnInsertConfig.setActionCommand("insertConfig");
            bttnInsertConfig.addActionListener(debug);
            JButton bttnDelete = new JButton(JAPMessages.getString("bttnDelete"), GUIUtils.loadImageIcon("deleteicon.gif", true));
            bttnDelete.setActionCommand("delete");
            bttnDelete.addActionListener(debug);
            JButton bttnClose = new JButton(JAPMessages.getString("bttnClose"), GUIUtils.loadImageIcon("exiticon.gif", true));
            bttnClose.setActionCommand("close");
            bttnClose.addActionListener(debug);
            GridBagLayout g = new GridBagLayout();
            panel.setLayout(g);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(5, 5, 5, 5);
            c.gridy = 0;
            c.gridx = 1;
            c.weightx = 0.0;
            g.setConstraints(bttnSave, c);
            panel.add(bttnSave);
            c.gridx = 2;
            g.setConstraints(bttnCopy, c);
            panel.add(bttnCopy);
            c.gridx = 3;
            g.setConstraints(bttnInsertConfig, c);
            panel.add(bttnInsertConfig);
            c.gridx = 4;
            g.setConstraints(bttnDelete, c);
            panel.add(bttnDelete);
            c.weightx = 1.0;
            c.anchor = 13;
            c.fill = 0;
            c.gridx = 5;
            g.setConstraints(bttnClose, c);
            panel.add(bttnClose);
            m_frameConsole.getContentPane().add("North", panel);
            m_frameConsole.getContentPane().add("Center", new JScrollPane(m_textareaConsole));
            m_frameConsole.addWindowListener(this.m_winAdapter);
            m_frameConsole.pack();
            m_frameConsole.moveToUpRightCorner();
            m_frameConsole.setVisible(true);
            m_bConsole = true;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("saveas")) {
            this.saveLog();
        } else if (e.getActionCommand().equals("copy")) {
            m_textareaConsole.selectAll();
            m_textareaConsole.copy();
            m_textareaConsole.moveCaretPosition(m_textareaConsole.getCaretPosition());
        } else if (e.getActionCommand().equals("delete")) {
            m_textareaConsole.setText("");
        } else if (e.getActionCommand().equals("insertConfig")) {
            try {
                Properties p = System.getProperties();
                Enumeration<?> enumer = p.propertyNames();
                while (enumer.hasMoreElements()) {
                    String st = (String)enumer.nextElement();
                    String value = p.getProperty(st);
                    m_textareaConsole.append(st + ": " + value + "\n");
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            m_textareaConsole.append("TotalMemory: " + Util.formatBytesValueWithUnit(Runtime.getRuntime().totalMemory()) + "\n");
            try {
                Long result = (Long)(class$java$lang$Runtime == null ? (class$java$lang$Runtime = JAPDebug.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("maxMemory", new Class[0]).invoke((Object)Runtime.getRuntime(), new Object[0]);
                m_textareaConsole.append("MaxMemory: " + Util.formatBytesValueWithUnit(result) + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_textareaConsole.append("FreeMemory: " + Util.formatBytesValueWithUnit(Runtime.getRuntime().freeMemory()) + "\n");
            m_textareaConsole.append("\n");
            m_textareaConsole.append(JAPModel.getInstance().toString());
        } else {
            m_frameConsole.dispose();
            m_bConsole = false;
        }
    }

    private void saveLog() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        int ret = fc.showDialog(m_frameConsole.getRootPane(), null);
        if (ret == 0) {
            File file = fc.getSelectedFile();
            try {
                FileWriter fw = new FileWriter(file);
                m_textareaConsole.write(fw);
                fw.flush();
                fw.close();
            }
            catch (Exception e) {
                JAPDialog.showErrorDialog(m_frameConsole, JAPMessages.getString("errWritingLog"));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_bConsole = false;
        ms_bFile = false;
        ms_strFileName = null;
        ms_FileLog = null;
        dateFormatter = new SimpleDateFormat("yyyy/MM/dd-hh:mm:ss, ");
    }
}

