/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.tor.FirstOnionRouterConnection;
import anon.tor.Tor;
import anon.tor.ordescription.ORDescriptor;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class FirstOnionRouterConnectionFactory {
    private Vector m_firstOnionRouters = new Vector();
    private Tor m_Tor;

    public FirstOnionRouterConnectionFactory(Tor a_Tor) {
        this.m_Tor = a_Tor;
    }

    public synchronized FirstOnionRouterConnection createFirstOnionRouterConnection(ORDescriptor d) {
        FirstOnionRouterConnection fOR = null;
        for (int i = 0; i < this.m_firstOnionRouters.size(); ++i) {
            fOR = (FirstOnionRouterConnection)this.m_firstOnionRouters.elementAt(i);
            ORDescriptor ord = fOR.getORDescription();
            if (ord.isSimilar(d)) {
                if (fOR.isClosed()) break;
                return fOR;
            }
            fOR = null;
        }
        if (fOR == null) {
            fOR = new FirstOnionRouterConnection(d, this.m_Tor);
        }
        try {
            fOR.connect();
        }
        catch (Exception ex) {
            LogHolder.log(2, LogType.TOR, "Error while connection to first OnionRouter");
            LogHolder.log(2, LogType.TOR, ex);
            return null;
        }
        this.m_firstOnionRouters.addElement(fOR);
        return fOR;
    }

    public synchronized void closeAll() {
        for (int i = 0; i < this.m_firstOnionRouters.size(); ++i) {
            FirstOnionRouterConnection fOR = (FirstOnionRouterConnection)this.m_firstOnionRouters.elementAt(i);
            fOR.close();
        }
        this.m_firstOnionRouters.removeAllElements();
    }
}

