/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.forwarder;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;

public class MailForwarder {
    private static final String DEFAULT_CONFIG_FILE = "mailsystem.conf";
    private static final int BUFFER_SIZE = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] a_args) throws Exception {
        String configFileName = DEFAULT_CONFIG_FILE;
        if (a_args != null) {
            for (int i = 0; i < a_args.length; ++i) {
                if (!a_args[i].equalsIgnoreCase("-config")) continue;
                if (i + 1 >= a_args.length) break;
                configFileName = a_args[i + 1];
                break;
            }
        }
        Properties mailConfig = new Properties();
        FileInputStream configurationFile = new FileInputStream(configFileName);
        try {
            mailConfig.load(configurationFile);
        }
        finally {
            if (configurationFile != null) {
                try {
                    configurationFile.close();
                }
                catch (Exception exception) {}
            }
        }
        int mainProcessPort = Integer.parseInt(mailConfig.getProperty("MailSystemMainProcessPort").trim());
        Socket mainProcessSocket = null;
        try {
            mainProcessSocket = new Socket((String)null, mainProcessPort);
            OutputStream streamToMainProcess = mainProcessSocket.getOutputStream();
            byte[] buffer = new byte[1000];
            int bytesRead = System.in.read(buffer);
            while (bytesRead != -1) {
                streamToMainProcess.write(buffer, 0, bytesRead);
                bytesRead = System.in.read(buffer);
            }
        }
        finally {
            if (mainProcessSocket != null) {
                try {
                    mainProcessSocket.getOutputStream().close();
                }
                catch (Exception exception) {}
                try {
                    mainProcessSocket.getInputStream().close();
                }
                catch (Exception exception) {}
                try {
                    mainProcessSocket.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

