/*
 * Decompiled with CFR 0.152.
 */
package infoservice.dynamic;

import anon.infoservice.MixCascade;
import infoservice.dynamic.ADynamicCascadeBuildingStrategy;
import infoservice.dynamic.DynamicConfiguration;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class ComleteRandomStrategy
extends ADynamicCascadeBuildingStrategy {
    @Override
    public Vector createCascades(Vector firstMixes, Vector middleMixes, Vector lastMixes, long seed) throws Exception {
        Vector firstAndMiddleMixes = new Vector();
        firstAndMiddleMixes.addAll(firstMixes);
        firstAndMiddleMixes.addAll(middleMixes);
        return this.circuit(firstAndMiddleMixes, lastMixes, seed);
    }

    public Vector circuit(Vector firstAndMiddleMixes, Vector lastMixes, long seedForRandomGenerator) throws Exception {
        int j;
        Vector cascArr;
        int i;
        if (firstAndMiddleMixes == null || firstAndMiddleMixes.size() == 0 || lastMixes == null || lastMixes.size() == 0) {
            throw new Exception("Invalid parameters");
        }
        if (firstAndMiddleMixes.size() < DynamicConfiguration.getInstance().getMaxCascadeLength() - 1 || lastMixes.size() == 0) {
            throw new Exception("Not enough mixes to build cascades");
        }
        Random r = new Random(seedForRandomGenerator);
        firstAndMiddleMixes = this.randomizeVector(firstAndMiddleMixes, r);
        lastMixes = this.randomizeVector(lastMixes, r);
        int ratioFirstQuantity = 3;
        boolean ratioSecondQuantity = true;
        boolean ratioThirdQuantity = true;
        int numberOfFirstAndMiddleMixes = firstAndMiddleMixes.size();
        int numberOfLastMixes = lastMixes.size();
        int amountOfQuantityOne = 0;
        int amountOfQuantityTwo = 0;
        int amountOfQuantityThree = 0;
        boolean thereAreEnoughMixesAvailable = true;
        LogHolder.log(7, LogType.ALL, "Count of last mixes:  " + numberOfLastMixes);
        LogHolder.log(7, LogType.ALL, "Count of middle and lfirst mixes: " + numberOfFirstAndMiddleMixes);
        LogHolder.log(7, LogType.ALL, "Upper bound for length: " + DynamicConfiguration.getInstance().getMaxCascadeLength());
        LogHolder.log(7, LogType.ALL, "Lower bound for length: " + DynamicConfiguration.getInstance().getMinCascadeLength());
        block0: while (thereAreEnoughMixesAvailable) {
            int i2;
            for (i2 = 0; i2 < 3; ++i2) {
                if (numberOfLastMixes - 1 >= 0 && numberOfFirstAndMiddleMixes - DynamicConfiguration.getInstance().getMaxCascadeLength() + 1 >= 0) {
                    --numberOfLastMixes;
                    numberOfFirstAndMiddleMixes -= DynamicConfiguration.getInstance().getMaxCascadeLength() - 1;
                    ++amountOfQuantityOne;
                    continue;
                }
                thereAreEnoughMixesAvailable = false;
                break;
            }
            if (DynamicConfiguration.getInstance().getMaxCascadeLength() - 1 >= DynamicConfiguration.getInstance().getMinCascadeLength()) {
                for (i2 = 0; i2 < 1; ++i2) {
                    if (thereAreEnoughMixesAvailable && numberOfLastMixes - 1 >= 0 && numberOfFirstAndMiddleMixes - DynamicConfiguration.getInstance().getMaxCascadeLength() + 2 >= 0) {
                        --numberOfLastMixes;
                        numberOfFirstAndMiddleMixes -= DynamicConfiguration.getInstance().getMaxCascadeLength() - 2;
                        ++amountOfQuantityTwo;
                        continue;
                    }
                    thereAreEnoughMixesAvailable = false;
                    break;
                }
            }
            if (DynamicConfiguration.getInstance().getMaxCascadeLength() - 2 < DynamicConfiguration.getInstance().getMinCascadeLength()) continue;
            for (i2 = 0; i2 < 1; ++i2) {
                if (thereAreEnoughMixesAvailable && numberOfLastMixes - 1 >= 0 && numberOfFirstAndMiddleMixes - DynamicConfiguration.getInstance().getMaxCascadeLength() + 3 >= 0) {
                    --numberOfLastMixes;
                    numberOfFirstAndMiddleMixes -= DynamicConfiguration.getInstance().getMaxCascadeLength() - 3;
                    ++amountOfQuantityThree;
                    continue;
                }
                thereAreEnoughMixesAvailable = false;
                continue block0;
            }
        }
        Vector<MixCascade> result = new Vector<MixCascade>();
        int firstAndMiddleMixesIndex = 0;
        int lastMixesIndex = 0;
        for (i = 0; i < amountOfQuantityOne; ++i) {
            cascArr = new Vector(DynamicConfiguration.getInstance().getMaxCascadeLength());
            for (j = 1; j < DynamicConfiguration.getInstance().getMaxCascadeLength(); ++j) {
                cascArr.addElement(firstAndMiddleMixes.get(firstAndMiddleMixesIndex));
                ++firstAndMiddleMixesIndex;
            }
            cascArr.addElement(lastMixes.get(lastMixesIndex));
            ++lastMixesIndex;
            result.addElement(this.buildCascade(cascArr));
        }
        for (i = 0; i < amountOfQuantityTwo; ++i) {
            cascArr = new Vector(DynamicConfiguration.getInstance().getMaxCascadeLength() - 1);
            for (j = 1; j < DynamicConfiguration.getInstance().getMaxCascadeLength() - 1; ++j) {
                cascArr.addElement(firstAndMiddleMixes.get(firstAndMiddleMixesIndex));
                ++firstAndMiddleMixesIndex;
            }
            cascArr.addElement(lastMixes.get(lastMixesIndex));
            ++lastMixesIndex;
            result.addElement(this.buildCascade(cascArr));
        }
        for (i = 0; i < amountOfQuantityThree; ++i) {
            cascArr = new Vector(DynamicConfiguration.getInstance().getMaxCascadeLength() - 2);
            for (j = 1; j < DynamicConfiguration.getInstance().getMaxCascadeLength() - 2; ++j) {
                cascArr.addElement(firstAndMiddleMixes.get(firstAndMiddleMixesIndex));
                ++firstAndMiddleMixesIndex;
            }
            cascArr.addElement(lastMixes.get(lastMixesIndex));
            ++lastMixesIndex;
            result.addElement(this.buildCascade(cascArr));
        }
        LogHolder.log(6, LogType.ALL, "Cascades of length " + DynamicConfiguration.getInstance().getMaxCascadeLength() + " : " + amountOfQuantityOne);
        LogHolder.log(6, LogType.ALL, "Cascades of length " + (DynamicConfiguration.getInstance().getMaxCascadeLength() - 1) + " : " + amountOfQuantityTwo);
        LogHolder.log(6, LogType.ALL, "Cascades of length " + (DynamicConfiguration.getInstance().getMaxCascadeLength() - 2) + " : " + amountOfQuantityThree);
        LogHolder.log(6, LogType.ALL, "Remaining last mixes:             " + numberOfLastMixes);
        LogHolder.log(6, LogType.ALL, "Remaining middle and first: " + numberOfFirstAndMiddleMixes);
        while (firstAndMiddleMixesIndex < firstAndMiddleMixes.size()) {
            Vector cascArr2 = new Vector();
            cascArr2.add(firstAndMiddleMixes.get(firstAndMiddleMixesIndex));
            result.add(this.buildCascade(cascArr2));
            ++firstAndMiddleMixesIndex;
        }
        while (lastMixesIndex < lastMixes.size()) {
            Vector cascArr3 = new Vector();
            cascArr3.add(lastMixes.get(lastMixesIndex));
            result.add(this.buildCascade(cascArr3));
            ++lastMixesIndex;
        }
        return result;
    }

    private Vector randomizeIt(Vector a_vector, int[] a_randArr) {
        Vector result = new Vector(a_vector.size());
        int posOfBiggestValue = -1;
        int biggestValue = -1;
        for (int j = 0; j < a_randArr.length; ++j) {
            posOfBiggestValue = -1;
            biggestValue = -1;
            for (int i = 0; i < a_randArr.length; ++i) {
                if (a_randArr[i] <= biggestValue) continue;
                biggestValue = a_randArr[i];
                posOfBiggestValue = i;
            }
            result.addElement(a_vector.get(posOfBiggestValue));
            a_randArr[posOfBiggestValue] = -1;
        }
        return result;
    }

    private Vector randomizeVector(Vector a_vector, Random a_random) {
        int[] randArray = new int[a_vector.size()];
        for (int i = 0; i < randArray.length; ++i) {
            randArray[i] = Math.abs(a_random.nextInt());
        }
        return this.randomizeIt(a_vector, randArray);
    }
}

