/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast.messages;

import anon.util.XMLUtil;
import infoservice.agreement.logging.GiveThingsAName;
import infoservice.agreement.multicast.AgreementMessageTypes;
import infoservice.agreement.multicast.messages.AMessage;
import infoservice.agreement.multicast.messages.EchoMessage;
import infoservice.agreement.multicast.messages.InitMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommitMessage
extends AMessage {
    private Hashtable m_EchoMessages = null;
    private InitMessage m_initMessage = null;

    public CommitMessage(InitMessage a_msg, String a_senderId, Hashtable a_echoMessages) {
        super(a_msg.getConsensusId(), 2, a_msg.getInitiatorsId(), a_msg.getProposal(), a_msg.getLastCommonRandom());
        this.m_initMessage = a_msg;
        this.m_senderId = a_senderId;
        this.m_EchoMessages = a_echoMessages;
    }

    public Hashtable getEchoMessages() {
        return this.m_EchoMessages;
    }

    @Override
    public String getHashKey() {
        StringBuffer buf = new StringBuffer();
        buf.append("Initiator: " + this.getInitiatorsId());
        buf.append(" <" + AgreementMessageTypes.getTypeAsString(this.getMessageType()) + ">");
        buf.append(" Proposal: " + this.getProposal());
        buf.append(" Senders Id: " + this.getSenderId());
        buf.append(" LCR: " + this.m_lastCommonRandom.toString());
        EchoMessage echo = null;
        Enumeration en = this.m_EchoMessages.elements();
        while (en.hasMoreElements()) {
            echo = (EchoMessage)en.nextElement();
            buf.append(echo.getHashKey());
        }
        return buf.toString();
    }

    public InitMessage getInitMessage() {
        return this.m_initMessage;
    }

    public void setEchoMessages(Hashtable a_echoMessages) {
        this.m_EchoMessages = a_echoMessages;
    }

    @Override
    public String toString() {
        String sendersName = GiveThingsAName.getNameForNumber(this.m_senderId);
        String initiatorsName = GiveThingsAName.getNameForNumber(this.getInitiatorsId());
        StringBuffer buf = new StringBuffer();
        buf.append("ConsensusID: " + this.m_consensusId.substring(0, 2));
        buf.append(" SenderId: " + sendersName);
        buf.append(" Initiator: " + initiatorsName);
        buf.append(" <" + AgreementMessageTypes.getTypeAsString(this.getMessageType()) + ">");
        buf.append(" Proposal: " + this.getProposal());
        buf.append(" LCR: " + this.m_lastCommonRandom.toString().substring(0, 2));
        EchoMessage echo = null;
        Enumeration en = this.m_EchoMessages.elements();
        while (en.hasMoreElements()) {
            echo = (EchoMessage)en.nextElement();
            buf.append("\n     EchoMessage" + echo);
        }
        return buf.toString();
    }

    @Override
    protected void appendCustomNodes(Document a_doc, Node a_rootElem) {
        Element tmp = a_doc.createElement("SenderId");
        XMLUtil.setValue((Node)tmp, this.m_senderId);
        a_rootElem.appendChild(tmp);
        Element echoes = a_doc.createElement("EchoMessages");
        a_rootElem.appendChild(echoes);
        Enumeration en = this.m_EchoMessages.keys();
        while (en.hasMoreElements()) {
            EchoMessage msg = (EchoMessage)this.m_EchoMessages.get(en.nextElement());
            Node node = msg.toXML().getFirstChild();
            if (node == null) {
                LogHolder.log(1, LogType.NET, "Node was null again, thats bad!");
                continue;
            }
            Node msgNode = a_doc.importNode(node, true);
            echoes.appendChild(msgNode);
        }
    }
}

