/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.ResourceLoader;
import anon.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.crypto.digests.MD5Digest;

public class RecursiveFileTool {
    private static final int INIT_DEPTH = 0;
    private static final int MAX_DEPTH_IGNORE = -2;
    private static final int COPY_BUFFER_SIZE = 1024;
    private static final int EOF = -1;

    public static File readFileName(String a_fileName) {
        int iLast = -1;
        if (a_fileName == null) {
            return null;
        }
        if (System.getProperty("os.name", "").toLowerCase().indexOf("win") < 0) {
            int iFound;
            while ((iFound = a_fileName.indexOf(92, iLast + 1)) >= 0) {
                if (a_fileName.length() > iFound + 1) {
                    if (a_fileName.charAt(iFound + 1) == '\\') {
                        iLast = iFound;
                    }
                    if (iLast == iFound || Character.isWhitespace(a_fileName.charAt(iFound + 1))) {
                        a_fileName = a_fileName.substring(0, iFound) + a_fileName.substring(iFound + 1, a_fileName.length());
                    }
                    iLast = iFound;
                    continue;
                }
                a_fileName = a_fileName.substring(0, iFound);
            }
        }
        return new File(a_fileName);
    }

    public static void copy(File src, File dest) {
        if (src == null) {
            LogHolder.log(2, LogType.MISC, "Source file is null: This should never happen");
            return;
        }
        if (dest == null) {
            LogHolder.log(2, LogType.MISC, "Destination file is null: This should never happen");
            return;
        }
        if (src.isDirectory()) {
            LogHolder.log(3, LogType.MISC, "File " + src.getName() + " is a directory: cannot copy it");
            return;
        }
        if (!src.exists()) {
            LogHolder.log(3, LogType.MISC, "There is no such file or directory: " + src.getName());
            return;
        }
        try {
            RecursiveFileTool.copySingleFile(src, dest);
        }
        catch (IOException ioe) {
            LogHolder.log(2, LogType.MISC, "An IO Exception while copying file " + src.getName() + ": " + ioe.getMessage());
        }
    }

    public static void copyRecursive(File src, File dest) {
        RecursiveFileTool.copyRecursion(src, dest, 0, -2);
    }

    public static void copyRecursive(File src, File dest, int maxDepth) {
        RecursiveFileTool.copyRecursion(src, dest, 0, maxDepth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyRecursion(File src, File dest, int depth, int maxDepth) {
        if (src == null) {
            LogHolder.log(2, LogType.MISC, "Source file is null: This should never happen");
            return;
        }
        if (dest == null) {
            LogHolder.log(2, LogType.MISC, "Destination file is null: This should never happen");
            return;
        }
        if (dest.getAbsolutePath().startsWith(src.getAbsolutePath())) {
            LogHolder.log(3, LogType.MISC, "destination path is in source path: to avoid endless loops, operation is not allowed");
            return;
        }
        if (!src.exists()) {
            LogHolder.log(3, LogType.MISC, "There is no such file or directory: " + src.getName());
            return;
        }
        if (src.isDirectory()) {
            String[] filesInCurrentDirectory = src.list();
            boolean directoryCreated = dest.mkdir();
            if (!directoryCreated) {
                LogHolder.log(3, LogType.MISC, "Cannot create directory: " + dest.getName());
                return;
            }
            int i = 0;
            while (i < filesInCurrentDirectory.length) {
                String currentFileName = filesInCurrentDirectory[i];
                if (maxDepth == -2 || depth < maxDepth) {
                    RecursiveFileTool.copyRecursion(new File(src.getAbsolutePath() + File.separator + currentFileName), new File(dest.getAbsolutePath() + File.separator + currentFileName), depth + 1, maxDepth);
                }
                ++i;
            }
            return;
        }
        try {
            RecursiveFileTool.copySingleFile(src, dest);
            return;
        }
        catch (IOException ioe) {
            LogHolder.log(2, LogType.MISC, "An IO Exception while copying file " + src.getName() + ": " + ioe.getMessage());
        }
    }

    static void copySingleFile(File src, File dest) throws IOException {
        FileInputStream fromSrcFile = new FileInputStream(src);
        RecursiveFileTool.copySingleFile(fromSrcFile, dest);
        Util.closeStream(fromSrcFile);
    }

    public static boolean deleteRecursion(File src) {
        if (src == null) {
            LogHolder.log(2, LogType.MISC, "Source file is null: This should never happen");
            return true;
        }
        if (!src.exists()) {
            LogHolder.log(3, LogType.MISC, "There is no such file or directory: " + src.getName());
            return true;
        }
        if (src.isDirectory()) {
            String[] filesInCurrentDirectory = src.list();
            for (int i = 0; filesInCurrentDirectory != null && i < filesInCurrentDirectory.length; ++i) {
                String currentFileName = filesInCurrentDirectory[i];
                RecursiveFileTool.deleteRecursion(new File(src.getAbsolutePath() + File.separator + currentFileName));
            }
        }
        String lstr = src.getName() + (src.delete() ? " was successfully deleted." : " was not successfully deleted.");
        LogHolder.log(7, LogType.MISC, lstr);
        return !src.exists();
    }

    static void copySingleFile(InputStream src, File dest) throws IOException {
        IOException ex = null;
        if (src == null) {
            LogHolder.log(3, LogType.MISC, "Abort copy process: InputStream is null");
            return;
        }
        FileOutputStream toDestFile = null;
        try {
            toDestFile = new FileOutputStream(dest);
            byte[] copyBuffer = new byte[1024];
            int bytesReadFromSrcFile = 1;
            while (src.available() > 0 && (bytesReadFromSrcFile = src.read(copyBuffer)) != -1) {
                toDestFile.write(copyBuffer, 0, bytesReadFromSrcFile);
            }
        }
        catch (IOException ioe) {
            ex = ioe;
        }
        try {
            if (toDestFile != null) {
                toDestFile.close();
            }
            src.close();
        }
        catch (IOException ioe1) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static boolean equals(File a_oneFile, byte[] a_md5HashSecond, long a_sizeSecond) {
        block3: {
            try {
                if (Util.arraysEqual(RecursiveFileTool.createMD5Digest(a_oneFile), a_md5HashSecond)) {
                    return true;
                }
            }
            catch (Exception a_e) {
                if (a_oneFile.length() != a_sizeSecond) break block3;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(File a_oneFile, File a_otherFile, boolean a_doHashComparison) {
        boolean bComparedQuick = false;
        if (a_oneFile == null || a_otherFile == null) {
            return false;
        }
        try {
            if (!a_oneFile.exists() || !a_otherFile.exists()) {
                return false;
            }
            bComparedQuick = true;
        }
        catch (SecurityException a_e) {
            LogHolder.log(2, LogType.MISC, a_e);
        }
        try {
            if (a_oneFile.length() != a_otherFile.length()) {
                return false;
            }
            bComparedQuick = true;
        }
        catch (SecurityException a_e) {
            LogHolder.log(2, LogType.MISC, a_e);
        }
        if (!a_doHashComparison && bComparedQuick) {
            return true;
        }
        try {
            if (!Util.arraysEqual(RecursiveFileTool.createMD5Digest(a_oneFile), RecursiveFileTool.createMD5Digest(a_otherFile))) {
                return false;
            }
        }
        catch (IOException a_e) {
            LogHolder.log(2, LogType.MISC, a_e);
            return false;
        }
        catch (SecurityException a_e) {
            LogHolder.log(2, LogType.MISC, a_e);
        }
        return true;
    }

    public static long getFileSize(File a_file) throws SecurityException {
        if (a_file == null || !a_file.exists()) {
            return -1L;
        }
        return a_file.length();
    }

    public static byte[] createMD5Digest(File a_file) throws IOException, SecurityException {
        byte[] content = ResourceLoader.getStreamAsBytes(new FileInputStream(a_file));
        MD5Digest digest = new MD5Digest();
        byte[] hash2 = new byte[digest.getDigestSize()];
        digest.update(content, 0, content.length);
        digest.doFinal(hash2, 0);
        return hash2;
    }
}

