/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.mmrdescription;

import anon.crypto.MyRSAPublicKey;
import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.RoutingInformation;
import anon.util.Base64;
import anon.util.ByteArrayUtil;
import java.io.LineNumberReader;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import logging.LogHolder;
import logging.LogType;

public class MMRDescription {
    private String m_address;
    private String m_name;
    private int m_port;
    private MyRSAPublicKey m_IdentityKey;
    private MyRSAPublicKey m_PacketKey;
    private byte[] m_digest;
    private byte[] m_keydigest;
    private boolean m_isExitNode;
    private boolean m_allowsFragmened;
    private String m_software;
    private SimpleDateFormat m_published;
    private static String m_time;

    public MMRDescription(String address, String name, int port, byte[] digest, byte[] keydigest, boolean exit, boolean fragmented, String software, SimpleDateFormat published) {
        this.m_address = address;
        this.m_name = name;
        this.m_port = port;
        this.m_digest = digest;
        this.m_keydigest = keydigest;
        this.m_isExitNode = exit;
        this.m_allowsFragmened = fragmented;
        this.m_software = software;
        this.m_published = published;
    }

    public boolean setIdentityKey(byte[] identitykey) {
        this.m_IdentityKey = MyRSAPublicKey.getInstance(identitykey);
        return this.m_IdentityKey != null;
    }

    public MyRSAPublicKey getIdentityKey() {
        return this.m_IdentityKey;
    }

    public SimpleDateFormat getPublished() {
        return this.m_published;
    }

    public boolean setPacketKey(byte[] packetKey) {
        this.m_PacketKey = MyRSAPublicKey.getInstance(packetKey);
        return this.m_PacketKey != null;
    }

    public MyRSAPublicKey getPacketKey() {
        return this.m_PacketKey;
    }

    public byte[] getDigest() {
        return this.m_digest;
    }

    public byte[] getKeyDigest() {
        return this.m_keydigest;
    }

    public boolean isExitNode() {
        return this.m_isExitNode;
    }

    public boolean allowsFragmented() {
        return this.m_allowsFragmened;
    }

    public String getAddress() {
        return this.m_address;
    }

    public String getName() {
        return this.m_name;
    }

    public int getPort() {
        return this.m_port;
    }

    public RoutingInformation getRoutingInformation() {
        RoutingInformation ri = new RoutingInformation();
        ri.m_Type = (short)3;
        ri.m_Content = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(this.m_port, 2), this.m_keydigest, this.m_address.getBytes());
        return ri;
    }

    public String getSoftwareVersion() {
        return this.m_software;
    }

    public static ExitInformation getExitInformation(String[] email, byte[] decodinghandle) {
        ExitInformation exitInformation = new ExitInformation();
        byte[] arRand = null;
        if (decodinghandle == null) {
            SecureRandom rand = new SecureRandom();
            arRand = new byte[20];
            rand.nextBytes(arRand);
            arRand[0] = (byte)(arRand[0] & 0x7F);
        } else {
            arRand = decodinghandle;
        }
        if (email.length < 1) {
            exitInformation.m_Type = 0;
            exitInformation.m_Content = arRand;
            LogHolder.log(3, LogType.MISC, "[Building ExitInformation]: no Recipients; Packet will be dropped! ");
            return exitInformation;
        }
        exitInformation.m_Type = (short)256;
        String mail = email[0];
        arRand = ByteArrayUtil.conc(arRand, mail.getBytes());
        exitInformation.m_Content = arRand;
        return exitInformation;
    }

    public static MMRDescription parse(LineNumberReader reader) {
        try {
            String pd;
            reader.readLine();
            String nickname = reader.readLine().substring(10);
            byte[] identity = Base64.decode(reader.readLine().substring(10));
            byte[] digest = Base64.decode(reader.readLine().substring(8));
            byte[] signature = Base64.decode(reader.readLine().substring(11));
            m_time = pd = reader.readLine().substring(11, 21);
            SimpleDateFormat published = new SimpleDateFormat("yyyy-MM-dd");
            published.parse(pd);
            reader.readLine();
            reader.readLine();
            byte[] packetkey = Base64.decode(reader.readLine().substring(12));
            reader.readLine();
            String software = reader.readLine().substring(10);
            reader.readLine();
            reader.readLine();
            reader.readLine();
            reader.readLine();
            reader.readLine();
            reader.readLine();
            reader.readLine();
            String hostname = reader.readLine().substring(10);
            String port = reader.readLine().substring(6);
            if (port.startsWith("gest")) {
                return null;
            }
            byte[] keydigest = Base64.decode(reader.readLine().substring(12));
            reader.readLine();
            reader.readLine();
            reader.readLine();
            reader.readLine();
            String temp = "";
            boolean exitNode = false;
            boolean mbox = false;
            boolean fragmented = false;
            while (!(temp = reader.readLine()).startsWith("[Testing]")) {
                if (temp.startsWith("[Delivery/SMTP]")) {
                    exitNode = true;
                }
                if (temp.startsWith("[Delivery/MBOX]")) {
                    mbox = true;
                }
                if (!temp.startsWith("[Delivery/Fragmented")) continue;
                fragmented = true;
            }
            MMRDescription mmrd = new MMRDescription(hostname, nickname, Integer.parseInt(port), digest, keydigest, exitNode, fragmented, software, published);
            if (!mmrd.setIdentityKey(identity) || !mmrd.setPacketKey(packetkey)) {
                return null;
            }
            return mmrd;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "MMRRouter: " + this.m_name + " Exitnode:" + this.m_isExitNode + " FRAGS: " + this.allowsFragmented() + "Published: " + m_time;
    }
}

