/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.CompositeFileEntryParser;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.NTFTPEntryParser;
import org.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import org.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.apache.commons.net.ftp.parser.VMSVersioningFTPEntryParser;

public class DefaultFTPFileEntryParserFactory
implements FTPFileEntryParserFactory {
    public FTPFileEntryParser createFileEntryParser(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            return (FTPFileEntryParser)clazz.newInstance();
        }
        catch (Exception exception) {
            String string2 = null;
            if (null != string) {
                string2 = string.toUpperCase();
            }
            if (string2.indexOf("UNIX") >= 0) {
                return this.createUnixFTPEntryParser();
            }
            if (string2.indexOf("VMS") >= 0) {
                return this.createVMSVersioningFTPEntryParser();
            }
            if (string2.indexOf("WINDOWS") >= 0) {
                return this.createNTFTPEntryParser();
            }
            if (string2.indexOf("OS/2") >= 0) {
                return this.createOS2FTPEntryParser();
            }
            if (string2.indexOf("OS/400") >= 0) {
                return this.createOS400FTPEntryParser();
            }
            throw new ParserInitializationException("Unknown parser type: " + string);
        }
        catch (Throwable throwable) {
            throw new ParserInitializationException("Error initializing parser", throwable);
        }
    }

    public FTPFileEntryParser createUnixFTPEntryParser() {
        return new UnixFTPEntryParser();
    }

    public FTPFileEntryParser createVMSVersioningFTPEntryParser() {
        return new VMSVersioningFTPEntryParser();
    }

    public FTPFileEntryParser createNTFTPEntryParser() {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NTFTPEntryParser(), new UnixFTPEntryParser()});
    }

    public FTPFileEntryParser createOS2FTPEntryParser() {
        return new OS2FTPEntryParser();
    }

    public FTPFileEntryParser createOS400FTPEntryParser() {
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new OS400FTPEntryParser(), new UnixFTPEntryParser()});
    }
}

